DELIMITER $$
DROP PROCEDURE IF EXISTS V20220525113044__Insert_CourseFeeDefCreditConfLoader $$
CREATE PROCEDURE V20220525113044__Insert_CourseFeeDefCreditConfLoader()
BEGIN

IF NOT EXISTS ((SELECT * FROM `import_utility_master` WHERE screenName = 'Import Bulk Course Fee Definition Credit Based' and  
code ='CourseFeeDefinitionCreditBased')) THEN 
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`)
 VALUES ('Bulk Course Fee Definition Credit Based', 'fees/CourseFeeDefinitionCreditBased', 'CourseFeeDefinitionCreditBased', '1');
END IF;

SET @importUtilityMasterId=(SELECT id FROM import_utility_master where code='CourseFeeDefinitionCreditBased');

#-------------------------Is School------------------------------------------------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COURSE_DEPARTMENT_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('COURSE_DEPARTMENT_HEADER', 'Course Department', 'Course Department', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COURSE_CODE_PRINT_NAME_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('COURSE_CODE_PRINT_NAME_HEADER', 'Course Code / Course Print Name', 'Course Code / Course Print Name', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COURSE_FEE_DEFINITION_NAME' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('COURSE_FEE_DEFINITION_NAME', 'Course Fee Definition Name', 'Course Fee Definition Name', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
 END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_TYPE' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('FEE_TYPE', 'Fee Type', 'Fee Type', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
 END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COURSE_FEE_HEAD' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('COURSE_FEE_HEAD', 'Course Fee head', 'Course Fee head', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
 END IF;
 
IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DEFAULT_FEE_DEFINITION' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('DEFAULT_FEE_DEFINITION', 'Default Fee Definition', 'Default Fee Definition', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
 END IF;

#----------- Is School Sub Fee Head--------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_1' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_1', 'Fee Sub Head', 'Fee Sub Head', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_2' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_2', 'Fee Sub Head', 'Fee Sub Head', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_3' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_3', 'Fee Sub Head', 'Fee Sub Head', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_4' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_4', 'Fee Sub Head', 'Fee Sub Head', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_5' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_5', 'Fee Sub Head', 'Fee Sub Head', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_6' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_6', 'Fee Sub Head', 'Fee Sub Head', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_7' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_7', 'Fee Sub Head', 'Fee Sub Head', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_8' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_8', 'Fee Sub Head', 'Fee Sub Head', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_9' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_9', 'Fee Sub Head', 'Fee Sub Head', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_10' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_10', 'Fee Sub Head', 'Fee Sub Head', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

#----------- Is School Fee Sub Head Amt --------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_1' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_1', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_2' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_2', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_3' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_3', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_4' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_4', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_5' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_5', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_6' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_6', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_7' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_7', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_8' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_8', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_9' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_9', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_10' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_10', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

#----------- Is School Cost Center --------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_1' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_1', 'Cost Center', 'Cost Center', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_2' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_2', 'Cost Center', 'Cost Center', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_3' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_3', 'Cost Center', 'Cost Center', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_4' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_4', 'Cost Center', 'Cost Center', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_5' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_5', 'Cost Center', 'Cost Center', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_6' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_6', 'Cost Center', 'Cost Center', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_7' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('COST_CENTER_7', 'Cost Center', 'Cost Center', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
 END IF;
 
IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_8' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_8', 'Cost Center', 'Cost Center', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_9' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_9', 'Cost Center', 'Cost Center', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_10' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_10', 'Cost Center', 'Cost Center', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

#----------- Is School Refundable --------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_1' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_1', 'Refundable', 'Refundable', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_2' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_2', 'Refundable', 'Refundable', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_3' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_3', 'Refundable', 'Refundable', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_4' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_4', 'Refundable', 'Refundable', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_5' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_5', 'Refundable', 'Refundable', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_6' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_6', 'Refundable', 'Refundable', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_7' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_7', 'Refundable', 'Refundable', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_8' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_8', 'Refundable', 'Refundable', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_9' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_9', 'Refundable', 'Refundable', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_10' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_10', 'Refundable', 'Refundable', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

#----------- Is School Refundable Rule --------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_1' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_RULE_1', 'Refundable Rule', 'Refundable Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_2' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_RULE_2', 'Refundable Rule', 'Refundable Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_3' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_RULE_3', 'Refundable Rule', 'Refundable Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_4' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_RULE_4', 'Refundable Rule', 'Refundable Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_5' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_RULE_5', 'Refundable Rule', 'Refundable Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_6' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_RULE_6', 'Refundable Rule', 'Refundable Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_7' and isSchool='1')) THEN
 INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('REFUNDABLE_RULE_7', 'Refundable Rule', 'Refundable Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
 END IF;
 
IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_8' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_RULE_8', 'Refundable Rule', 'Refundable Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_9' and isSchool='1')) THEN
 INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('REFUNDABLE_RULE_9', 'Refundable Rule', 'Refundable Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
 END IF;
 
IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_10' and isSchool='1')) THEN
 INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('REFUNDABLE_RULE_10', 'Refundable Rule', 'Refundable Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
 END IF;

#----------- Is School Discount Rule --------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_1' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_1', 'Discount Rule', 'Discount Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_2' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_2', 'Discount Rule', 'Discount Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_3' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_3', 'Discount Rule', 'Discount Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_4' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_4', 'Discount Rule', 'Discount Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_5' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_5', 'Discount Rule', 'Discount Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_6' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_6', 'Discount Rule', 'Discount Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_7' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_7', 'Discount Rule', 'Discount Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_8' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_8', 'Discount Rule', 'Discount Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_9' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_9', 'Discount Rule', 'Discount Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_10' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_10', 'Discount Rule', 'Discount Rule', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;


#-------------------------Is College------------------------------------------------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COURSE_DEPARTMENT_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('COURSE_DEPARTMENT_HEADER', 'Course Department', 'Course Department', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COURSE_CODE_PRINT_NAME_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('COURSE_CODE_PRINT_NAME_HEADER', 'Course Code / Course Print Name', 'Course Code / Course Print Name', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COURSE_FEE_DEFINITION_NAME' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('COURSE_FEE_DEFINITION_NAME', 'Course Fee Definition Name', 'Course Fee Definition Name', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
 END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_TYPE' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('FEE_TYPE', 'Fee Type', 'Fee Type', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
 END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COURSE_FEE_HEAD' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('COURSE_FEE_HEAD', 'Course Fee head', 'Course Fee head', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
 END IF;
 
IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DEFAULT_FEE_DEFINITION' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('DEFAULT_FEE_DEFINITION', 'Default Fee Definition', 'Default Fee Definition', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
 END IF;

#----------- Is College Sub Fee Head--------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_1' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_1', 'Fee Sub Head', 'Fee Sub Head', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_2' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_2', 'Fee Sub Head', 'Fee Sub Head', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_3' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_3', 'Fee Sub Head', 'Fee Sub Head', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_4' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_4', 'Fee Sub Head', 'Fee Sub Head', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_5' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_5', 'Fee Sub Head', 'Fee Sub Head', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_6' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_6', 'Fee Sub Head', 'Fee Sub Head', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_7' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_7', 'Fee Sub Head', 'Fee Sub Head', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_8' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_8', 'Fee Sub Head', 'Fee Sub Head', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_9' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_9', 'Fee Sub Head', 'Fee Sub Head', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_10' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, `isNonEditable`, 
`isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_10', 'Fee Sub Head', 'Fee Sub Head', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

#----------- Is College Fee Sub Head Amt --------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_1' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_1', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_2' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_2', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_3' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_3', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_4' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_4', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_5' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_5', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_6' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_6', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_7' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_7', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_8' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_8', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_9' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_9', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FEE_SUB_HEAD_AMOUNT_10' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('FEE_SUB_HEAD_AMOUNT_10', 'Sub Fee Head Weightage', 'Sub Fee Head Weightage', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

#----------- Is College Cost Center --------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_1' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_1', 'Cost Center', 'Cost Center', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_2' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_2', 'Cost Center', 'Cost Center', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_3' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_3', 'Cost Center', 'Cost Center', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_4' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_4', 'Cost Center', 'Cost Center', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_5' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_5', 'Cost Center', 'Cost Center', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_6' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_6', 'Cost Center', 'Cost Center', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_7' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('COST_CENTER_7', 'Cost Center', 'Cost Center', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
 END IF;
 
IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_8' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_8', 'Cost Center', 'Cost Center', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_9' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_9', 'Cost Center', 'Cost Center', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COST_CENTER_10' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COST_CENTER_10', 'Cost Center', 'Cost Center', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

#----------- Is College Refundable --------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_1' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_1', 'Refundable', 'Refundable', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_2' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_2', 'Refundable', 'Refundable', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_3' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_3', 'Refundable', 'Refundable', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_4' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_4', 'Refundable', 'Refundable', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_5' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_5', 'Refundable', 'Refundable', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_6' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_6', 'Refundable', 'Refundable', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_7' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_7', 'Refundable', 'Refundable', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_8' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_8', 'Refundable', 'Refundable', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_9' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_9', 'Refundable', 'Refundable', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_10' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_10', 'Refundable', 'Refundable', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

#----------- Is College Refundable Rule --------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_1' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_RULE_1', 'Refundable Rule', 'Refundable Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_2' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_RULE_2', 'Refundable Rule', 'Refundable Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_3' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_RULE_3', 'Refundable Rule', 'Refundable Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_4' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_RULE_4', 'Refundable Rule', 'Refundable Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_5' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_RULE_5', 'Refundable Rule', 'Refundable Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_6' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_RULE_6', 'Refundable Rule', 'Refundable Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_7' and isSchool='0')) THEN
 INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('REFUNDABLE_RULE_7', 'Refundable Rule', 'Refundable Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
 END IF;
 
IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_8' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('REFUNDABLE_RULE_8', 'Refundable Rule', 'Refundable Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_9' and isSchool='0')) THEN
 INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('REFUNDABLE_RULE_9', 'Refundable Rule', 'Refundable Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
 END IF;
 
IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='REFUNDABLE_RULE_10' and isSchool='0')) THEN
 INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
 `isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
 VALUES ('REFUNDABLE_RULE_10', 'Refundable Rule', 'Refundable Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
 END IF;

#----------- Is College Discount Rule --------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_1' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_1', 'Discount Rule', 'Discount Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_2' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_2', 'Discount Rule', 'Discount Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_3' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_3', 'Discount Rule', 'Discount Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_4' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_4', 'Discount Rule', 'Discount Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_5' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_5', 'Discount Rule', 'Discount Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_6' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_6', 'Discount Rule', 'Discount Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_7' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_7', 'Discount Rule', 'Discount Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_8' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_8', 'Discount Rule', 'Discount Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_9' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_9', 'Discount Rule', 'Discount Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='DISCOUNT_RULE_10' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`, 
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('DISCOUNT_RULE_10', 'Discount Rule', 'Discount Rule', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;


END $$
CALL V20220525113044__Insert_CourseFeeDefCreditConfLoader() $$
DROP PROCEDURE IF EXISTS V20220525113044__Insert_CourseFeeDefCreditConfLoader $$
DELIMITER ;