DELIMITER $$
DROP PROCEDURE IF EXISTS V20220530151847__Create_academicTopicDocuments $$
CREATE PROCEDURE V20220530151847__Create_academicTopicDocuments()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='academic_topic_documents')) THEN 
CREATE TABLE `academic_topic_documents` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentId` bigint(20) NOT NULL,
  `studentAcademicTopicId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_academic_topic_documents_documents` (`documentId`),
  KEY `FK_academic_topic_documents_QTD` (`studentAcademicTopicId`),
  KEY `FK_academic_topic_documents_usersId` (`lastUpdatedBy`),
  CONSTRAINT `FK_academic_topic_documents_QTD` FOREIGN KEY (`studentAcademicTopicId`) REFERENCES `student_academic_topics` (`id`),
  CONSTRAINT `FK_academic_topic_documents_usersId` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `FK_academic_topic_documents_documents` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20220530151847__Create_academicTopicDocuments () $$ 
DROP PROCEDURE IF EXISTS V20220530151847__Create_academicTopicDocuments $$ 
DELIMITER ;