DELIMITER $$
DROP PROCEDURE IF EXISTS V20220726112133__Insert_AnantU_STD_Receipt $$
CREATE PROCEDURE V20220726112133__Insert_AnantU_STD_Receipt()
BEGIN

set @receipt = (select max(id) from report_type where typeName='Receipt with Settlement' );

IF NOT EXISTS ((select * from report_template where `templateCode`='MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE' and `templateName`='AnantU-student receipt')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@receipt, 'MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE', 'AnantU-student receipt', 'MANAGE_RECEIPT_SETTLEMENT_ANANTU.png', 'CommonReport.jasper', NULL, 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'MANAGE_RECEIPT_SETTLEMENT_STD_ANANTU.jasper', 'AcademiaLogo.png');

END IF; 

set @rsID = (select max(id) from report_template where templateCode ='MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE' and templateName = 'AnantU-student receipt');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_OFFICE_COPY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_OFFICE_COPY', 'OFFICE COPY', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_FEE_RECEIPT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_FEE_RECEIPT', 'Fee Receipt', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_STUDENT_DETAILS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_STUDENT_DETAILS', 'Student Details', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_STUDENTS_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_STUDENTS_NAME', "Student's" 'Name:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_BATCH')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_BATCH', 'Batch:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_ACADEMIC_YEAR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_ACADEMIC_YEAR', 'Academic Year:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_CURRENT_SEMESTER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_CURRENT_SEMESTER', 'Current Semester:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_STD_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_STD_ID', 'Student Id:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_PAYMENT_MODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_PAYMENT_MODE', 'Payment Mode:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_FEES_FOR_SEMESTER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_FEES_FOR_SEMESTER', 'Fees For Semester:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_RECEIPT_DETAILS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_RECEIPT_DETAILS', 'Receipt Details', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_RECEIPT_NUM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_RECEIPT_NUM', 'Receipt No.:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_RECEIPT_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_RECEIPT_DATE', 'Receipt Date:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_AMOUNT_PAYABLE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_AMOUNT_PAYABLE', 'Amount Payable:', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_TOTAL_OUTSTANDING_AMT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_TOTAL_OUTSTANDING_AMT', 'Total Outstanding Amount:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_FEE_HEAD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_FEE_HEAD', 'Fee Heads', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_PAYABLE_AMT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_PAYABLE_AMT', 'Payable Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_RUPY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_RUPY', '(Rs.)', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_RUPY1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_RUPY1', 'Rs.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_LATE_FEE_AMT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_LATE_FEE_AMT', 'Late Fee Amount', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_AMT_PAID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_AMT_PAID', 'Amount Paid', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_TOTAL_PAID_AMT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_TOTAL_PAID_AMT', 'Total Paid Amt:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_AMT_IN_WORD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_AMT_IN_WORD', 'Amount Received In Words', '1', now());
END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_INS_NUM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_INS_NUM', 'Instrument No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_INS_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_INS_DATE', 'Instrument Date', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_BANK_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_BANK_NAME', 'Bank Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_AMT_RECEIVED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_AMT_RECEIVED', 'Amount Received (Rs.)', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_TOTAL_OUT_AMT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_TOTAL_OUT_AMT', 'Total Outstanding Amount', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_NOTE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_NOTE', 'This is a Computer generated receipt, Seal and Signature is not required.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_STD_COPY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_STD_COPY', 'STUDENT COPY', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_WELCOME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_WELCOME', 'Welcome:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @rsID and keyValue='TRANS_AMOUNT_PAYABLE1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@rsID, 'TRANS_AMOUNT_PAYABLE1', 'Amount Payable:', '1', now());
END IF;
 

END $$
CALL V20220726112133__Insert_AnantU_STD_Receipt() $$
DROP PROCEDURE IF EXISTS V20220726112133__Insert_AnantU_STD_Receipt $$
DELIMITER ;