DELIMITER $$
DROP PROCEDURE IF EXISTS V20220823140458__Create_RegistrationGuidelinetTable $$
CREATE PROCEDURE V20220823140458__Create_RegistrationGuidelinetTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='registration_guidelines')) THEN 
CREATE TABLE `registration_guidelines` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `registrationSetupId` BIGINT NOT NULL,
  `ckeditorData` varchar(5000) DEFAULT NULL,
  `isRegistrationGuideline` BIT(1) NOT NULL DEFAULT b'0',
  `lastUpdatedBy` BIGINT  NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_setupId` FOREIGN KEY (`registrationSetupId`) REFERENCES `registration_term_setup_detail` (`id`),
  CONSTRAINT `fk_registration_guidelines_userId` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20220823140458__Create_RegistrationGuidelinetTable () $$ 
DROP PROCEDURE IF EXISTS V20220823140458__Create_RegistrationGuidelinetTable $$ 
DELIMITER ;