DELIMITER $$
DROP PROCEDURE IF EXISTS V20220919112455__Create_AccommodationProviderTable $$
CREATE PROCEDURE V20220919112455__Create_AccommodationProviderTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='accommodation_provider')) THEN 
CREATE TABLE accommodation_provider(
    id bigint(20) NOT NULL AUTO_INCREMENT ,
    providerCode varchar(50),
    accommodProviderName varchar(255),
    accreditationStatus varchar(30),
    contactPerson varchar(255),
    contactEmail varchar(100),
    status varchar(30),
    phoneNo varchar(20),
    phoneCountryCode varchar(10),
    mobileNo varchar(15),
    mobileCountryCode varchar(10),
    address text,
    roomsAvailable varchar(100),
	lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    lastUpdatedBy BIGINT(20) NOT NULL,
     PRIMARY KEY (id),
     CONSTRAINT aaccommodation_provider_lastUpdatedBy_FK FOREIGN KEY (lastUpdatedBy) REFERENCES users(id))
  ENGINE=INNODB DEFAULT  CHARSET=utf8;
  END IF; 

END $$
CALL V20220919112455__Create_AccommodationProviderTable () $$ 
DROP PROCEDURE IF EXISTS V20220919112455__Create_AccommodationProviderTable $$ 
DELIMITER ;