DELIMITER $$
DROP PROCEDURE IF EXISTS V20220923131643__Create_learning_target_new $$
CREATE PROCEDURE V20220923131643__Create_learning_target_new()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='learning_target_new')) THEN 
CREATE TABLE learning_target_new (
  id bigint NOT NULL AUTO_INCREMENT,
  reviewDate date DEFAULT NULL,
  nextReviewDate date DEFAULT NULL,
  facultyComment varchar(250) DEFAULT NULL,
  principalComment varchar(250) DEFAULT NULL,
  courseVariantId bigint DEFAULT NULL,
  periodId bigint NOT NULL,
  sectionId bigint DEFAULT NULL,
  evaluationPlanId bigint NOT NULL,
  evaluationSequenceId bigint DEFAULT NULL,
  evaluationPlanLevelTwoId bigint DEFAULT NULL,
  evaluationPlanLevelOneId bigint DEFAULT NULL,
  whetherApproved bit(1) DEFAULT b'0',
  lastUpdatedBy bigint NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_learning_new_periodId_idx (periodId) ,
  KEY fk_learning_new_target_lastUpdatedBy_idx (lastUpdatedBy),
  KEY fk_learning_new_planId_idx (evaluationPlanId),
  KEY fk_learning_new_levelOneId_idx (evaluationPlanLevelOneId),
  KEY fk_learning_new_levelTwoId_idx (evaluationPlanLevelTwoId) ,
  KEY fk_learning_new_levelThreeId_idx (evaluationSequenceId),
  KEY fk_learning_new_courseVariantId_idx (courseVariantId) ,
  KEY fk_learning_new_sectionId_idx (sectionId) ,
  CONSTRAINT fk_learning_target_new_courseVariantId FOREIGN KEY (courseVariantId) REFERENCES course_variants (id),
  CONSTRAINT fk_learning_target_new_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id),
  CONSTRAINT fk_learning_target_new_levelOneId FOREIGN KEY (evaluationPlanLevelOneId) REFERENCES evaluation_plan_level_one (id),
  CONSTRAINT fk_learning_target_new_levelThreeId FOREIGN KEY (evaluationSequenceId) REFERENCES evaluation_sequence (id),
  CONSTRAINT fk_learning_target_new_levelTwoId FOREIGN KEY (evaluationPlanLevelTwoId) REFERENCES evaluation_plan_level_two (id),
  CONSTRAINT fk_learning_target_new_periodId FOREIGN KEY (periodId) REFERENCES prog_batch_period_config (id),
  CONSTRAINT fk_learning_target_new_planId FOREIGN KEY (evaluationPlanId) REFERENCES evaluation_plan (id),
  CONSTRAINT fk_learning_target_new_sectionId FOREIGN KEY (sectionId) REFERENCES sections (id)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20220923131643__Create_learning_target_new () $$ 
DROP PROCEDURE IF EXISTS V20220923131643__Create_learning_target_new $$ 
DELIMITER ;