DELIMITER $$
DROP PROCEDURE IF EXISTS V20221013140514__Create_StudenTransferEvent $$
CREATE PROCEDURE V20221013140514__Create_StudenTransferEvent()
BEGIN

-- Student Transfer Notification
IF NOT EXISTS ((SELECT id FROM msg_category WHERE `code`='STUDENT_TRANSFER_NOTIFICATION')) THEN 

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'STUDENT_TRANSFER_NOTIFICATION');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='STUDENT_TRANSFER_NOTIFICATION');

INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'STUDENT_TRANSFER_NOTIFICATION', 'Student Transfer Notification', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Student Transfer Notification');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'STUDENT_TRANSFER_NOTIFICATION_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'STUDENT_TRANSFER_NOTIFICATION_RECIPIENT', 'SQL');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_TRANSFER_NOTIFICATION_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'STUDENT_TRANSFER_NOTIFICATION_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_TRANSFER_NOTIFICATION_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='STUDENT_TRANSFER_NOTIFICATION_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_TRANSFER_NOTIFICATION_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T1.id AS USER_ID
FROM
    service_requests T1
        LEFT JOIN
    service_request_settings T2 ON T2.id = T1.serviceRequestSettingId
        LEFT JOIN
    users T3 ON T3.id = T1.requester
WHERE T1.id IN (namedParams)",NULL);
-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_TRANSFER_NOTIFICATION_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    servicereq6_.id AS ID,
    (SELECT 
            approveruser.emailId
        FROM
            users AS approveruser
        WHERE
            approveruser.id = servicereq6_.lastUpdatedBy) AS EMAIL_ID,
    (SELECT 
            CONCAT(approveruser.firstName,
                        IFNULL(approveruser.middleName, ' '),
                        IFNULL(approveruser.lastName, ' '))
        FROM
            users AS approveruser
        WHERE
            approveruser.id = servicereq6_.lastUpdatedBy) AS FIRST_NAME,
(SELECT 
            CONCAT(approveruser.firstName,
                        IFNULL(approveruser.middleName, ' '),
                        IFNULL(approveruser.lastName, ' '))
        FROM
            users AS approveruser
        WHERE
            approveruser.id = servicereq6_.lastUpdatedBy) AS DEFAULT_APPROVER,
    (SELECT 
            per.mobileNumber
        FROM
            users AS approveruser
                LEFT JOIN
            staffs stt ON stt.userId = approveruser.id
                LEFT JOIN
            persons per ON per.id = approveruser.id
        WHERE
            approveruser.id = servicereq6_.lastUpdatedBy) AS MOBILE_NO,
    (select IFNULL(itemValue, ' ') as  itemValue from registration_type as rt WHERE rt.id = toprogram7_.registrationTypeId AND  toprogram7_.registrationTypeId IS NOT NULL AND rt.id IS NOT NULL) AS PROGRAM_STATUS,
    tobatch8_.batchName AS BATCH_NAME,
     toprogram7_.programName AS PROGRAM_NAME,
       CONCAT(fromal2_.academyName,
            '-',
            fromal2_.locationName) AS FROM_LOCATION,
    CONCAT(CONCAT(person5_.firstName, ' '),
            IFNULL(CONCAT(person5_.middleName, ' '), ''),
            IFNULL(CONCAT(person5_.lastName, ' '), '')) AS STUDENT_NAME,
    CONCAT(toal3_.academyName,
            '-',
            toal3_.locationName) AS TO_LOCATION,
            student4_1_.code AS STUDENT_ID
FROM
        student_transfer_request_details this_ 
    left outer join
        service_requests servicereq6_ 
            on this_.serviceRequestId=servicereq6_.id 
    left outer join
        staffs staff11_ 
            on servicereq6_.assigneeId=staff11_.userId 
    left outer join
        users staff11_1_ 
            on staff11_.userId=staff11_1_.id 
    left outer join
        users user12_ 
            on servicereq6_.enteredBy=user12_.id 
    left outer join
        parents user12_1_ 
            on user12_.id=user12_1_.userId 
    left outer join
        staffs user12_2_ 
            on user12_.id=user12_2_.userId 
    left outer join
        students user12_3_ 
            on user12_.id=user12_3_.userId 
    left outer join
        users user13_ 
            on servicereq6_.parentsId=user13_.id 
    left outer join
        parents user13_1_ 
            on user13_.id=user13_1_.userId 
    left outer join
        staffs user13_2_ 
            on user13_.id=user13_2_.userId 
    left outer join
        students user13_3_ 
            on user13_.id=user13_3_.userId 
    left outer join
        programs program14_ 
            on servicereq6_.currentProgram=program14_.id 
    left outer join
        request_status requeststa15_ 
            on servicereq6_.requestStatusId=requeststa15_.id 
    left outer join
        users user16_ 
            on servicereq6_.requester=user16_.id 
    left outer join
        parents user16_1_ 
            on user16_.id=user16_1_.userId 
    left outer join
        staffs user16_2_ 
            on user16_.id=user16_2_.userId 
    left outer join
        students user16_3_ 
            on user16_.id=user16_3_.userId 
    left outer join
        sections section17_ 
            on servicereq6_.currentSection=section17_.id 
    left outer join
        academy_location fromal2_ 
            on this_.fromALId=fromal2_.id 
    left outer join
        currency currency19_ 
            on fromal2_.currencyId=currency19_.id 
    left outer join
        admission fromadmiss1_ 
            on this_.fromAdmissionId=fromadmiss1_.id 
    left outer join
        students student4_ 
            on fromadmiss1_.studentId=student4_.userId 
    left outer join
        users student4_1_ 
            on student4_.userId=student4_1_.id 
    left outer join
        persons person5_ 
            on student4_.personId=person5_.id 
    left outer join
        drop_down dropdown23_ 
            on this_.reasonForLeaving=dropdown23_.id 
    left outer join
        academy_location toal3_ 
            on this_.toALId=toal3_.id 
    left outer join
        batches tobatch8_ 
            on this_.toBatchId=tobatch8_.id 
    left outer join
        batches_cd batchcusto26_ 
            on tobatch8_.id=batchcusto26_.batchId 
    left outer join
        programs toprogram7_ 
            on this_.toProgramId=toprogram7_.id 
    left outer join
        program_cd programcus28_ 
            on toprogram7_.id=programcus28_.programId 
    where
        servicereq6_.id IN (namedParams)
LIMIT 1",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "TO_LOCATION",
            "resultKey": "TO_LOCATION",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "STUDENT_ID",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "FROM_LOCATION",
            "resultKey": "FROM_LOCATION",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "STUDENT_NAME",
            "resultKey": "STUDENT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "BATCH_NAME",
            "resultKey": "BATCH_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "PROGRAM_NAME",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "PROGRAM_STATUS",
            "resultKey": "PROGRAM_STATUS",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "ID",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 7       
		 },
		{
            "id": 9,
            "value": "DEFAULT_APPROVER",
            "resultKey": "DEFAULT_APPROVER",
            "displayCode": "",
            "displayOrder": 8        
		}
    ]}');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='STUDENT_TRANSFER_NOTIFICATION');


SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='STUDENT_TRANSFER_NOTIFICATION');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='STUDENT_TRANSFER_NOTIFICATION_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Student Transfer Notification',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Student Transfer Notification',NULL,'',NULL,'','APPROVED','','1','System Admin','1','English',b'1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Student Transferred','<html><head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="padding:0px 0px 0px 20px;">Dear&nbsp;<strong>$recipientData[&quot;DEFAULT_APPROVER&quot;]</strong>,</p>
			<p style="padding:0px 0px 0px 20px;">Please note that applicant- $recipientData[&quot;STUDENT_NAME&quot;] - $recipientData[&quot;STUDENT_ID&quot;] <br />
             has been transferred from $recipientData[&quot;FROM_LOCATION&quot;] to $recipientData[&quot;TO_LOCATION&quot;] <br />for the $recipientData[&quot;PROGRAM_NAME&quot;]&nbsp;$recipientData[&quot;BATCH_NAME&quot;] $recipientData[&quot;PROGRAM_STATUS&quot;] intake </p>
			</td>
		</tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'4','Student Transferred','<html><head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="padding:0px 0px 0px 20px;">Dear&nbsp;<strong>$recipientData[&quot;DEFAULT_APPROVER&quot;]</strong>,</p>
			<p style="padding:0px 0px 0px 20px;">Please note that applicant- $recipientData[&quot;STUDENT_NAME&quot;] - $recipientData[&quot;STUDENT_ID&quot;] <br />
             has been transferred from $recipientData[&quot;FROM_LOCATION&quot;] to $recipientData[&quot;TO_LOCATION&quot;] <br />for the $recipientData[&quot;PROGRAM_NAME&quot;]&nbsp;$recipientData[&quot;BATCH_NAME&quot;] $recipientData[&quot;PROGRAM_STATUS&quot;] intake </p>
			</td>
		</tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2','Transfer Approved','Dear $recipientData[&quot;DEFAULT_APPROVER&quot;], Please note that applicant $recipientData[&quot;STUDENT_NAME&quot;] $recipientData[&quot;STUDENT_ID&quot;] has been transferred from $recipientData[&quot;FROM_LOCATION&quot;] to $recipientData[&quot;TO_LOCATION&quot;] for the $recipientData[&quot;PROGRAM_NAME&quot;] $recipientData[&quot;BATCH_NAME&quot;] $recipientData[&quot;PROGRAM_STATUS&quot;] intake');

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='FROM_LOCATION')) THEN 
 INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
 VALUES ('MESSAGING_TRANSLATIONS','FROM_LOCATION',"From Location","From Location","Van ligging","Từ vị trí",now(),1);
 END IF; 
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='TO_LOCATION')) THEN 
 INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
 VALUES ('MESSAGING_TRANSLATIONS','TO_LOCATION',"To Location","To Location","Na Ligging","Đến vị trí",now(),1);
 END IF; 
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='PROGRAM_STATUS')) THEN 
 INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
 VALUES ('MESSAGING_TRANSLATIONS','PROGRAM_STATUS',"Program Status","Program Status","Program Status","Trạng thái chương trình",now(),1);
 END IF;  
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='DEFAULT_APPROVER')) THEN 
 INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
 VALUES ('MESSAGING_TRANSLATIONS','DEFAULT_APPROVER',"Default Approver","Default Approver","Verstekgoedkeurder","Người phê duyệt mặc định",now(),1);
 END IF; 
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='STUDENT_TRANSFER_NOTIFICATION')) THEN 
 INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
 VALUES ('MESSAGING_TRANSLATIONS','STUDENT_TRANSFER_NOTIFICATION',"Student Transfer Notification","Student Transfer Notification","Studente-oordragkennisgewing","Thông báo chuyển trường của sinh viên",now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE  `key`='STUDENT_TRANSFER_NOTIFICATION')) THEN 
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('STUDENT_TRANSFER_NOTIFICATION', 'Student Transfer Notification');
END IF;

END IF; 

END $$
CALL V20221013140514__Create_StudenTransferEvent () $$ 
DROP PROCEDURE IF EXISTS V20221013140514__Create_StudenTransferEvent $$ 
DELIMITER ;