DELIMITER $$
DROP PROCEDURE IF EXISTS V20221115144826__Create_programCourseGroupMapping $$
CREATE PROCEDURE V20221115144826__Create_programCourseGroupMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_course_group_mapping')) THEN 
CREATE TABLE `program_course_group_mapping` (
 `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
 `programId` BIGINT(20) NOT NULL,
 `courseGroupId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
 `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
 PRIMARY KEY (`id`),
 INDEX `fk_program_Id_idx` (`programId` ASC),
 INDEX `fk_course_group_Id_idx` (`courseGroupId` ASC),
 INDEX `fk_applicant_person_interventions_lastUpdateBy_idx` (`lastUpdatedBy` ASC),
 CONSTRAINT `fk_program_Id_id`
 FOREIGN KEY (`programId`)
REFERENCES `programs` (`id`),
 CONSTRAINT `fk_course_group_Id`
 FOREIGN KEY (`courseGroupId`)
REFERENCES `course_group` (`id`)  
ON DELETE RESTRICT
ON UPDATE RESTRICT);
END IF;
 

END $$
CALL V20221115144826__Create_programCourseGroupMapping () $$ 
DROP PROCEDURE IF EXISTS V20221115144826__Create_programCourseGroupMapping $$ 
DELIMITER ;