DELIMITER $$
DROP PROCEDURE IF EXISTS V20221126103249__Insert_FeePayerIDDynamicDoc $$
CREATE PROCEDURE V20221126103249__Insert_FeePayerIDDynamicDoc()
BEGIN

IF EXISTS ((SELECT * FROM `dydt_data_line_item` where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO')) THEN 
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId = (SELECT MIN(dataProviderId) FROM `dydt_data_line_item` where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO');
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`
, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'FEE_PAYER_ID', '8',null, '1', '0', 
"select fd.feePayerID AS FEE_PAYER_ID
    from 
    fee_payer_detail fd 
     left outer join 
    students st on st.personId = fd.personId
	 left outer join
    admission a on a.studentId = st.userId", 
    'PRM_ADMISSION_ID', 
	'FEE_PAYER_ID',
"where a.id=PRM_ADMISSION_ID and a.activeStatus=TRUE",false);

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('FEE_PAYER_ID', 'Fee Payer ID',@dydtdatalinitemId+1);
END IF; 

END $$
CALL V20221126103249__Insert_FeePayerIDDynamicDoc() $$
DROP PROCEDURE IF EXISTS V20221126103249__Insert_FeePayerIDDynamicDoc $$
DELIMITER ;