DELIMITER $$
DROP PROCEDURE IF EXISTS V20221227113250__Create_Aggregations_Csm $$
CREATE PROCEDURE V20221227113250__Create_Aggregations_Csm()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='aggregations')) THEN 
CREATE TABLE `aggregations` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(100) NOT NULL,
	`itemValue` VARCHAR(100) NOT NULL,
    `itemCodeOtherLanguage` VARCHAR(100) NULL,
    `itemValueOtherLanguage` VARCHAR(100) NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	UNIQUE KEY itemCode_UNIQUE (itemCode),
	CONSTRAINT `aggregations_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

-- CSM Data

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'aggregations')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'aggregations','AGGREGATIONS','Admissions','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;


IF  EXISTS ((SELECT * FROM standard_master WHERE tableName = 'aggregations')) THEN 
SET @standardMasterId=(SELECT id FROM standard_master WHERE tableName = 'aggregations');
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='AGGREGATION_CODE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','AGGREGATION_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterId AND fieldLabel='AGGREGATION_NAME')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','AGGREGATION_NAME',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;


IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE  dbFieldName='itemCodeOtherLanguage' AND fieldLabel='AGGREGATION_CODE_IN_OTHER_LANGUAGE' AND standardMasterId=@standardMasterId)) THEN
INSERT INTO standard_master_items( `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES ('itemCodeOtherLanguage', 'AGGREGATION_CODE_IN_OTHER_LANGUAGE', @standardMasterId, 'Varchar', '3', 0, 0, 0, true, '1', SYSDATE());
END IF;

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE  dbFieldName='itemValueOtherLanguage' AND fieldLabel='AGGREGATION_NAME_IN_OTHER_LANGUAGE' AND standardMasterId=@standardMasterId)) THEN
INSERT INTO standard_master_items( `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES ('itemValueOtherLanguage', 'AGGREGATION_NAME_IN_OTHER_LANGUAGE', @standardMasterId, 'Varchar', '4', 0, 0, 0, true, '1', SYSDATE());
END IF;
END IF;

END $$
CALL V20221227113250__Create_Aggregations_Csm () $$ 
DROP PROCEDURE IF EXISTS V20221227113250__Create_Aggregations_Csm $$ 
DELIMITER ;