DELIMITER $$
DROP PROCEDURE IF EXISTS V20230524145641__Create_Create_student_bank_detail $$
CREATE PROCEDURE V20230524145641__Create_Create_student_bank_detail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_bank_detail')) THEN 
CREATE TABLE `student_bank_detail` (
`id` bigint(20) NOT NULL AUTO_INCREMENT,
`beneficiaryName` varchar(250) DEFAULT NULL,
`beneficiaryNameOtherLanguage` varchar(250) DEFAULT NULL,
`accountNumber` bigint(30) DEFAULT NULL,
`accountTypeId` bigint(20) DEFAULT NULL,
`bankDrawnOnMasterId` bigint(20) DEFAULT NULL,
`bankDrawnChildId` bigint(20) DEFAULT NULL,
`studentId` bigint(20) DEFAULT NULL,
`lastUpdatedBy` bigint(20) NOT NULL,
`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

PRIMARY KEY (`id`),
FOREIGN KEY (`accountTypeId`)REFERENCES `account_type`(`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`bankDrawnOnMasterId`)REFERENCES `bank_drawn_on_master`(`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`bankDrawnChildId`)REFERENCES `bank_drawn_child`(`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
FOREIGN KEY (`studentId`) REFERENCES `students`(`userId`)
);
	
END IF; 

END $$
CALL V20230524145641__Create_Create_student_bank_detail () $$ 
DROP PROCEDURE IF EXISTS V20230524145641__Create_Create_student_bank_detail $$ 
DELIMITER ;