DELIMITER $$
DROP PROCEDURE IF EXISTS `rpt_Application_Summary`$$
CREATE PROCEDURE `rpt_Application_Summary`(academyLocation text, intakeYear int(10), StartDate date, EndDate date, ProgramCategory int(10), ProgramGroup int(10), seatType text)
BEGIN

declare StartDateNull, EndDateNull, ProgramCategoryNull, ProgramGroupNull, SeatTypeNull boolean;

SET SQL_SAFE_UPDATES = 0;

call str_to_row (academyLocation);
call str_to_row_seattype (seatType);

if StartDate is null then
set StartDateNull = 1;
else set StartDateNull = 0;
end if;
if EndDate is null then
set EndDateNull = 1;
else set EndDateNull = 0;
end if;
if ProgramCategory is null then
set ProgramCategoryNull = 1;
else set ProgramCategoryNull = 0;
end if;
if ProgramGroup is null then
set ProgramGroupNull = 1;
else set ProgramGroupNull = 0;
end if;
if (seatType is null or seatType='')then
  	set SeatTypeNull = 1;
   else set SeatTypeNull = 0;
end if;
drop table if exists tbl_rpt_Application_Summary;
create table tbl_rpt_Application_Summary(Brand_Campus varchar(250), Brand_Campus_ID int, programId int, grade varchar(500), Total_SUCCESSFUL_Admission int default 0, Total_UNSuccessful int default 0, Total_Enq int default 0, convert_perc_lead double default 0, Weekly_movement_Tot_Success_Approve_Apps int default 0, Target_total_success_approv_apps int default 0, Perc_Target_Total_Success_Approve_App double default 0, YOY_Variance_Total_Approve_Application_target int default 0, Total_SUCCESSFUL_Admission_prev int default 0, total_converted_enq int default 0, Total_Application int default 0, Total_Interviews int default 0,programSequence int default 0)
comment 'Temporary Table for Application Summary Report';

insert into tbl_rpt_Application_Summary(Brand_Campus, Brand_Campus_ID, programId, grade,programSequence)
select concat(al.academyName, '-', al.locationName), al.id, p.id, p.programNameToBePrint,p.programSequence
from academy_location al join programs p on al.id = p.academyLocationId and p.status = 'O'
join batches as b on p.id = b.programId
join prog_batch_seat_config absc on absc.programBatchId=b.id
where p.programClosureDate is null
and al.id in (select s from tbl_str_to_row) and b.intakeYearId = intakeYear
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull) 
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, p.id;

update tbl_rpt_Application_Summary as t, (Select al.id as alId, count(distinct a.code) as Total_SUCCESSFUL_Admission, p.id as programid
from application a join application_program ap on a.id=ap.applicationId
join programs p on p.id=ap.programId
join academy_location al on al.id=ap.academyLocationId and al.id in (select s from tbl_str_to_row) 
join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id or (absc.seatTypeId in (select s from tbl_str_to_row_seattype))
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
where a.applicationCreationSource is not null
and a.currentStatus not in ('SUBMITTED','REJECTED','WITHDRAWN','DIRECT_SUBMISSION_TOKEN_GENERATED')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and (date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, p.id) as tot
set t.Total_SUCCESSFUL_Admission = tot.Total_SUCCESSFUL_Admission
where t.Brand_Campus_ID = tot.alId and t.programId = tot.programid;

update tbl_rpt_Application_Summary as t, (Select al.id as alId, count(distinct a.code) as Total_Application, p.id as programid
from application a join application_program ap on a.id=ap.applicationId
join programs p on p.id=ap.programId
join academy_location al on al.id=ap.academyLocationId and al.id in (select s from tbl_str_to_row)
join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id or (absc.seatTypeId in (select s from tbl_str_to_row_seattype))
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
where a.currentStatus in ('SUBMITTED','REJECTED', 'WITHDRAWN', 'APPROVED', 'ADMISSION_GRANTED')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and (date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, p.id) as tot
set t.Total_Application = tot.Total_Application
where t.Brand_Campus_ID = tot.alId and t.programId = tot.programid;

update tbl_rpt_Application_Summary as t, (Select al.id as alId, count(distinct a.code) as Total_Interviews, p.id as programid
from application a join application_program ap on a.id=ap.applicationId
join programs p on p.id=ap.programId
join academy_location al on al.id=ap.academyLocationId and al.id in (select s from tbl_str_to_row)
join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id or (absc.seatTypeId in (select s from tbl_str_to_row_seattype))
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
join program_selection_process as psp on psp.programBatchSeatConfigId = absc.id
join program_slctn_process_stages as ps on psp.id = ps.programSelectionProcessId and ps.currentStatus = 'INPROGRESS'
join application_prog_stage as aps on aps.applicationProgramId = ap.id and aps.currentStatus = 'INPROGRESS'
where
(date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and (date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, p.id) as tot
set t.Total_Interviews = tot.Total_Interviews
where t.Brand_Campus_ID = tot.alId and t.programId = tot.programid;

update tbl_rpt_Application_Summary as t, (Select al.id as alId, count(distinct a.id) as Total_UNSuccessful, p.id as programid
from application a join application_program ap on a.id=ap.applicationId
join programs p on p.id = ap.programId
join academy_location al on al.id = ap.academyLocationId and al.id in (select s from tbl_str_to_row)
join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id or (absc.seatTypeId in (select s from tbl_str_to_row_seattype))
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
where a.currentStatus in ('REJECTED','WITHDRAWN')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and (date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, p.id) as q
set t.Total_UNSuccessful = ifnull(q.Total_UNSuccessful,0)
where t.Brand_Campus_ID = q.alId and t.programid = q.programid;

update tbl_rpt_Application_Summary as t,
(select al.displayName, e.academyLocationId, p.programNameToBePrint, aed.programId, p.programName, count(distinct e.id) as Total_Enq
from academy_location as al, programs as p, enquiry e
join enq_student_details esd on esd.enquiryId = e.id
join admission_enq_details aed on aed.enqStudentDetailsId = esd.id
join prog_batch_seat_config absc on aed.progBatchSeatConfigId=absc.id or (absc.seatTypeId in (select s from tbl_str_to_row_seattype))
join seat_types st on st.id = absc.seatTypeId
join batches b on b.id = aed.batchId and b.intakeYearId = intakeYear
join intake_year iy on iy.id = b.intakeYearId
where e.academyLocationId in (select s from tbl_str_to_row) and al.id = e.academyLocationId
and aed.programId = p.id and p.status = 'O' and al.id = p.academyLocationId
and (((StartDate between b.startDate and b.tillDate) or 1 = StartDateNull)
or ((EndDate between b.startDate and b.tillDate) or 1 = EndDateNull))
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by e.academyLocationId, aed.programId) as q
set t.Total_Enq = q.Total_Enq
where t.Brand_Campus_ID = q.academyLocationId and t.programId = q.programId;

update tbl_rpt_Application_Summary as t, (Select al.id as alId, count(distinct a.id) as Total_sucessful_wrt_lead, p.id as programid
from application a join application_program ap on a.id=ap.applicationId
join programs p on p.id = ap.programId
join academy_location al on al.id = ap.academyLocationId and al.id in (select s from tbl_str_to_row)
join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id or (absc.seatTypeId in (select s from tbl_str_to_row_seattype))
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
where a.saleRefId is not null
group by al.id, p.id) as q
set t.convert_perc_lead = ifnull((q.Total_sucessful_wrt_lead/ t.total_enq) * 100,0),
t.total_converted_enq = ifnull(q.Total_sucessful_wrt_lead,0)
where t.Brand_Campus_ID = q.alId and t.programId = q.programId;

update tbl_rpt_Application_Summary as t, (select al.id as alid, ap.programId, count(distinct a.code) as app_this_week
from application a join application_program ap on a.id=ap.applicationId
join academy_location al on al.id = ap.academyLocationId and al.id in (select s from tbl_str_to_row)
join academy_location_purpose alp on al.id = alp.academyLocationId
join calendars on alp.calendarId = calendars.id
join programs p on p.id = ap.programId and p.status = 'O'
join prog_batch_seat_config absc on ap.progBatchSeatConfigId=absc.id or (absc.seatTypeId in (select s from tbl_str_to_row_seattype))
join batches b on b.id = absc.programBatchId and b.intakeYearId = intakeYear
where a.applicationCreatedOn between (date_sub(current_date(), interval WEEKDAY(current_date()) - (case when weekStart = 'MONDAY' then 0
when weekStart = 'TUESDAY' then 1
when weekStart = 'WEDNESDAY' then 2
when weekStart = 'THURSDAY' then 3
when weekStart = 'FRIDAY' then 4
when weekStart = 'SATURDAY' then 5 end) day)) and current_date()
and a.applicationCreationSource is not null
and a.currentStatus not in ('SUBMITTED','REJECTED','WITHDRAWN','DIRECT_SUBMISSION_TOKEN_GENERATED')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and (date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (absc.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, ap.programId) as q
set Weekly_movement_Tot_Success_Approve_Apps = q.app_this_week
where t.Brand_Campus_ID = q.alid and t.programId = q.programId;

update tbl_rpt_Application_Summary, (select mt.academyLocationId, applicationTarget as target_for_Total_success_approve_app, mt.intakeYearId, mt.programId, mt.batchId
from manage_target as mt join programs as p on p.id = mt.programId and mt.intakeYearId = intakeYear
join batches as b on b.programId = p.id
where mt.academyLocationId in (select s from tbl_str_to_row)
and (((StartDate between b.startDate and b.tillDate) or 1 = StartDateNull)
and ((EndDate between b.startDate and b.tillDate) or 1 = EndDateNull))
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)) as q
set tbl_rpt_Application_Summary.Target_total_success_approv_apps = ifnull(q.target_for_Total_success_approve_app,0)
where tbl_rpt_Application_Summary.Brand_Campus_ID = q.academyLocationId and tbl_rpt_Application_Summary.programId = q.programId;

update tbl_rpt_Application_Summary set Perc_Target_Total_Success_Approve_App = ifnull(Total_SUCCESSFUL_Admission / NULLIF(Target_total_success_approv_apps,0) * 100,0);

update tbl_rpt_Application_Summary as tbl, (select curr_intake.alId, curr_intake.id, prev_intake.Total_SUCCESSFUL_Admission as Total_SUCCESSFUL_Admission_prev, curr_intake.Total_SUCCESSFUL_Admission
, ifnull(((curr_intake.Total_SUCCESSFUL_Admission - prev_intake.Total_SUCCESSFUL_Admission)/NULLIF(prev_intake.Total_SUCCESSFUL_Admission,0) * 100),0) as YOY_Variance_Total_Approve_Application_target
from (Select count(distinct a.code) as Total_SUCCESSFUL_Admission, p.id, al.id as alId
from application a join application_program ap on a.id = ap.applicationId
join programs p on p.id = ap.programId
join academy_location al on al.id = ap.academyLocationId and al.id in (select s from tbl_str_to_row)
join prog_batch_seat_config as pb on ap.progBatchSeatConfigId = pb.id or (pb.seatTypeId in (select s from tbl_str_to_row_seattype))
join batches as b on b.id = pb.programBatchId and b.intakeYearId = intakeYear
where

a.applicationCreationSource is not null and
a.currentStatus not in ('SUBMITTED','REJECTED','WITHDRAWN','DIRECT_SUBMISSION_TOKEN_GENERATED')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and (date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (pb.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, p.id) as curr_intake
left join (Select count(distinct a.id) as Total_SUCCESSFUL_Admission, p.id, al.id as alId
from application a join application_program ap on a.id = ap.applicationId
join programs p on p.id = ap.programId
join academy_location al on al.id = ap.academyLocationId and al.id in (select s from tbl_str_to_row)
join prog_batch_seat_config as pb on ap.progBatchSeatConfigId = pb.id or (pb.seatTypeId in (select s from tbl_str_to_row_seattype))
join batches as b on b.id = pb.programBatchId and b.intakeYearId = (select id from intake_year
where itemValue = (select itemValue - 1 from intake_year where id = intakeYear))
where
a.applicationCreationSource is not null and
a.currentStatus not in ('SUBMITTED','REJECTED','WITHDRAWN','DIRECT_SUBMISSION_TOKEN_GENERATED')
and (date(a.applicationCreatedOn) >= StartDate or 1 = StartDateNull)
and (date(a.applicationCreatedOn)<= EndDate or 1 = EndDateNull)
and (p.programCategoryId = ProgramCategory or 1 = ProgramCategoryNull)
and (p.programGroupId = ProgramGroup or 1 = ProgramGroupNull)
and (pb.seatTypeId in (select s from tbl_str_to_row_seattype) or 1 = SeatTypeNull)
group by al.id, p.id) as prev_intake
on prev_intake.alId = curr_intake.alId and prev_intake.id = curr_intake.id) as dat
set tbl.YOY_Variance_Total_Approve_Application_target = dat.YOY_Variance_Total_Approve_Application_target
, tbl.Total_SUCCESSFUL_Admission_prev = dat.Total_SUCCESSFUL_Admission_prev
where tbl.Brand_Campus_Id = dat.alId and tbl.programId = dat.id;

select Brand_Campus, grade, Total_SUCCESSFUL_Admission, Total_UNSuccessful,
convert_perc_lead, Weekly_movement_Tot_Success_Approve_Apps, Target_total_success_approv_apps,
Perc_Target_Total_Success_Approve_App, YOY_Variance_Total_Approve_Application_target, total_enq,
Total_SUCCESSFUL_Admission_prev, total_converted_enq, Total_Application, Total_Interviews,programSequence
from tbl_rpt_Application_Summary order by Brand_Campus,programSequence;

END$$
DELIMITER ;