DELIMITER $$
DROP PROCEDURE IF EXISTS V20230601181959__Create_business_rule_course_mapping $$
CREATE PROCEDURE V20230601181959__Create_business_rule_course_mapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='business_rule_course_mapping')) THEN 
CREATE TABLE `business_rule_course_mapping` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `businessRuleId` BIGINT NOT NULL,
  `academyLocationId` BIGINT DEFAULT NULL,
  `academicTermId` BIGINT DEFAULT NULL,
  `courseId` BIGINT DEFAULT NULL,
  `courseVariantId` BIGINT DEFAULT NULL,
  `facultyId` BIGINT DEFAULT NULL,
  `departmentId` BIGINT DEFAULT NULL,
  `subDepartmentId` BIGINT DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT now(),
  `lastUpdatedBy` BIGINT NOT NULL,
   PRIMARY KEY (`id`),
  INDEX `fk_BRCM_businessRuleId_idx` (`businessRuleId` ASC),
  INDEX `fk_BRCM_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
  INDEX `fk_BRCM_academyLocationId_idx` (`academyLocationId` ASC),
  INDEX `fk_BRCM_academicTermId_idx` (`academicTermId` ASC),
  INDEX `fk_BRCM_courseId_idx` (`courseId` ASC),
  INDEX `fk_BRCM_courseVariantId_idx` (`courseVariantId` ASC),
  INDEX `fk_BRCM_facultyId_idx` (`facultyId` ASC),
  INDEX `fk_BRCM_departmentId_idx` (`departmentId` ASC),
   INDEX `fk_BRCM_subDepartmentId_idx` (`subDepartmentId` ASC),
  CONSTRAINT `fk_business_rule_course_mapping_businessRuleId`
    FOREIGN KEY (`businessRuleId`)
    REFERENCES `business_rule` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
		
    CONSTRAINT `fk_bbusiness_rule_course_mapping_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,

    CONSTRAINT `fk_business_rule_course_mapping_academyLocationId`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    
    CONSTRAINT `fk_business_rule_course_mapping_academicTermId`
    FOREIGN KEY (`academicTermId`)
    REFERENCES `academic_term` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,

    CONSTRAINT `fk_business_rule_course_mapping_courseId`
    FOREIGN KEY (`courseId`)
    REFERENCES `courses` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    
     CONSTRAINT `fk_business_rule_course_mapping_courseVariantId`
    FOREIGN KEY (`courseVariantId`)
    REFERENCES `course_variants` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    
     CONSTRAINT `fk_business_rule_course_mapping_facultyId`
    FOREIGN KEY (`facultyId`)
    REFERENCES `staffs` (`userid`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    
     CONSTRAINT `fk_business_rule_course_mapping_departmentId`
    FOREIGN KEY (`departmentId`)
    REFERENCES `department` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    
       CONSTRAINT `fk_business_rule_course_mapping_subDepartmentId`
    FOREIGN KEY (`subDepartmentId`)
    REFERENCES `department` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20230601181959__Create_business_rule_course_mapping () $$ 
DROP PROCEDURE IF EXISTS V20230601181959__Create_business_rule_course_mapping $$ 
DELIMITER ;