DELIMITER $$
DROP PROCEDURE IF EXISTS V20230612160620__Update_attendanceAbsentParent $$
CREATE PROCEDURE V20230612160620__Update_attendanceAbsentParent()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_FATHER_ABSENT_ONLY_RCPNT')) THEN 
SET @dtproviderIdFTR= (SELECT MIN(id) FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_FATHER_ABSENT_ONLY_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY, 
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
	LEFT JOIN
     parents AS T15 on T15.personId = T7.id
    LEFT JOIN
    users T16 on T16.id = T15.userId
    LEFT JOIN 
    fire_base_persons_info f ON f.userId = T16.id
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
T1.id IN (namedParams) AND T2.attendanceStatus = 'ABSENT' AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'FATHER'"  where dataProviderId = @dtproviderIdFTR;
END IF; 

IF EXISTS ((SELECT * FROM `msg_recipient_type` WHERE `code`='ATTENDANCE_COURSE_WISE_FATHER_ABSENT_ONLY_RCPNT')) THEN 
SET @msgrecipienttypeId= (SELECT MIN(id) FROM `msg_recipient_type` WHERE `code`='ATTENDANCE_COURSE_WISE_FATHER_ABSENT_ONLY_RCPNT');
SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config WHERE recipientTypeId = @msgrecipienttypeId );
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+1,@msgtemplateconfigId,'6','Message','Dear $recipientData["FIRST_NAME"] $recipientData["LAST_NAME"], $recipientData["STUDENT_FIRST_NAME"] $recipientData["STUDENT_LAST_NAME"] has been marked as $recipientData["ATTENDANCE_STATUS"] .');

END IF; 

IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_MOTHER_ABSENT_ONLY_RCPNT')) THEN 
SET @dtproviderIdMTR= (SELECT MAX(id) FROM dtprovider WHERE `dataProviderName`='ATTENDANCE_COURSE_WISE_MOTHER_ABSENT_ONLY_RCPNT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    T14.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	DATE_FORMAT(T10.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T10.toTime, '%h:%i %p') AS SLOT_TO,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS,
    ml.code as LANGUAGE_KEY, 
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    student_course_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_course_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    courses AS T14 ON T14.id = T10.courseId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
    LEFT JOIN
     parents AS T15 on T15.personId = T7.id
    LEFT JOIN
    users T16 on T16.id = T15.userId
    LEFT JOIN 
    fire_base_persons_info f ON f.userId = T16.id
WHERE (T7.isDeceased is null OR T7.isDeceased=FALSE) AND 
T1.id IN (namedParams) AND T2.attendanceStatus = 'PRESENT' AND T7.isMobUseForCommunication = TRUE AND T6.relationship = 'MOTHER'" where dataProviderId = @dtproviderIdMTR;

END IF; 

IF EXISTS ((SELECT * FROM `msg_recipient_type` WHERE `code`='ATTENDANCE_COURSE_WISE_FATHER_ABSENT_ONLY_RCPNT')) THEN 

SET @msgrecipienttypeId= (SELECT MIN(id) FROM `msg_recipient_type` WHERE `code`='ATTENDANCE_COURSE_WISE_MOTHER_ABSENT_ONLY_RCPNT'); 
SET @msgtemplateconfigId=(SELECT MIN(id) FROM msg_template_config WHERE recipientTypeId = @msgrecipienttypeId );
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+1,@msgtemplateconfigId,'6','Message','Dear $recipientData["FIRST_NAME"] $recipientData["LAST_NAME"], $recipientData["STUDENT_FIRST_NAME"] $recipientData["STUDENT_LAST_NAME"] has been marked as $recipientData["ATTENDANCE_STATUS"] .');

END IF; 

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230612160620__Update_attendanceAbsentParent () $$
DROP PROCEDURE IF EXISTS V20230612160620__Update_attendanceAbsentParent $$
DELIMITER ;