DELIMITER $$
DROP PROCEDURE IF EXISTS V20230614132512__Create_Create_StudentVisaDetailsTable $$
CREATE PROCEDURE V20230614132512__Create_Create_StudentVisaDetailsTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_visa_details')) THEN  
CREATE TABLE `student_visa_details`(
`id` bigint NOT NULL AUTO_INCREMENT,
`personId` bigint DEFAULT NULL,
`visaType` bigint DEFAULT NULL,
`countryOfIssue` bigint DEFAULT NULL,
`dateOfentryAllowance` date DEFAULT NULL,
`visaExpiryDate` date DEFAULT NULL,
`visaStatus` bigint DEFAULT NULL,
`visaAppliedDate` date DEFAULT NULL,
`visaIssuedDate` date DEFAULT NULL,
`visaCollectedDate` date DEFAULT NULL,
`visaCancellationDate` date DEFAULT NULL,
`reasonVisaRefused` varchar(500) DEFAULT NULL,
`isPrimary` bit(1) DEFAULT NULL,
`auditId` bigint NOT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_stdvisadetails_SU_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
CONSTRAINT `FK_stdvisadetails_SU_auditId` FOREIGN KEY (`auditId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_stdvisadetails_SU_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
CONSTRAINT `FK_stdvisadetails_SU_visaType_FK` FOREIGN KEY (`visaType`) REFERENCES `drop_down`(`id`),
CONSTRAINT `FK_stdvisadetails_SU_visaStatus_FK` FOREIGN KEY (`visaStatus`) REFERENCES `drop_down`(`id`),
CONSTRAINT `FK_stdvisadetails_SU_visaCountryOfIssue_FK` FOREIGN KEY (`countryOfIssue`) REFERENCES `country`(`id`)
);

END IF; 

END $$
CALL V20230614132512__Create_Create_StudentVisaDetailsTable () $$ 
DROP PROCEDURE IF EXISTS V20230614132512__Create_Create_StudentVisaDetailsTable $$ 
DELIMITER ;