DELIMITER $$
DROP PROCEDURE IF EXISTS V20230619151328__Create_TerminationRequestMultipleReason $$
CREATE PROCEDURE V20230619151328__Create_TerminationRequestMultipleReason()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='termination_request_multiple_reason')) THEN 
 CREATE TABLE `termination_request_multiple_reason` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `terminationRequestDetailId` BIGINT(20) NOT NULL,
  `terminationReasonId` BIGINT(20) NULL,
  `reasonRemark` varchar(250) NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_termination_request_multiple_reason_request_detail_idx` (`terminationRequestDetailId` ASC),
  INDEX `fk_termination_request_multiple_reason_termination_reason_idx` (`terminationReasonId` ASC),
  INDEX `fk_termination_request_multiple_reason_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_termination_multiple_reason_terminationRequestDetail_id`
    FOREIGN KEY (`terminationRequestDetailId`)
    REFERENCES `termination_request_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_termination_request_multiple_reason_termination_reason_id`
    FOREIGN KEY (`terminationReasonId`)
    REFERENCES `termination_reasons` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_termination_request_multiple_reasons_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20230619151328__Create_TerminationRequestMultipleReason () $$ 
DROP PROCEDURE IF EXISTS V20230619151328__Create_TerminationRequestMultipleReason $$ 
DELIMITER ;