DELIMITER $$
DROP PROCEDURE IF EXISTS V20230705174053__Update_monthlyReportMasterUpdatedSql $$
CREATE PROCEDURE V20230705174053__Update_monthlyReportMasterUpdatedSql()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='monthly_report_master')) THEN 
truncate monthly_report_master;
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (1,'number_of_als','SELECT \'Number of ALs\' AS value,COUNT(academy_location.id) AS code FROM academy_location JOIN academies ON academy_location.academyId = academies.id WHERE academicTypeCode IN (\'COLLEGE\' , \'UNIVERSITY\', \'SCHOOL\')','Summary','Number of Als',1,b'0','Academy Locations');
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (2,'programs','SELECT \'Programs\' AS value, COUNT(id) AS code FROM programs','Summary','Programs',1,b'0','Programs');
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (3,'course','SELECT \'Course\' AS value, COUNT(id) AS code FROM courses c WHERE c.parentCourseId IS NULL','Summary','Course',1,b'0','Course');
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (4,'number_of_employees_active','SELECT \'Number of Employees (Active)\' AS value,COUNT(DISTINCT (T8.id)) as code FROM staffs T1 LEFT JOIN department T12 ON T12.id =T1.departmentId INNER JOIN users T8 ON T8.id = T1.userId LEFT JOIN department T13 ON T13.id = T1.subDepartmentId AND T13.parentDepartmentId IS NOT NULL LEFT JOIN calendars T6 ON T6.id = T8.calendarId LEFT JOIN user_academy_locations T2 ON T8.id= T2.userId AND T2.WHETHERPRIMARY = TRUE LEFT JOIN user_groups T7 ON T7.id = T8.userGroupId LEFT JOIN user_acad_loc_roles T4 ON T2.id = T4.userAcadLocationId LEFT JOIN academy_location T3 ON T3.id = T2.academyLocationId LEFT JOIN roles T11 ON T11.id = T4.roleId WHERE T8.whetherDeleted = FALSE AND T8.status = TRUE AND T3.id IS NOT NULL;','Summary','Number of Employees (Active)',1,b'1','Active Employee');
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (5,'number_of_employees_inactive','SELECT \'Number of Employees (InActive)\' AS value,COUNT(DISTINCT (T8.id)) as code FROM staffs T1 LEFT JOIN department T12 ON T12.id = T1.departmentId INNER JOIN users T8 ON T8.id = T1.userId LEFT JOIN department T13 ON T13.id = T1.subDepartmentId AND T13.parentDepartmentId IS NOT NULL LEFT JOIN calendars T6 ON T6.id = T8.calendarId LEFT JOIN user_academy_locations T2 ON T8.id = T2.userId AND T2.WHETHERPRIMARY = TRUE LEFT JOIN user_groups T7 ON T7.id = T8.userGroupId LEFT JOIN user_acad_loc_roles T4 ON T2.id = T4.userAcadLocationId LEFT JOIN academy_location T3 ON T3.id = T2.academyLocationId LEFT JOIN roles T11 ON T11.id = T4.roleId WHERE T8.whetherDeleted = FALSE AND T8.status = FALSE;','\0','Number of Employees (InActive',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (6,'number_of_students_active','SELECT \'Number of Students (Active)\' AS value, COUNT(*) AS code FROM students T1 LEFT JOIN admission T3 ON T3.studentId = T1.userId LEFT JOIN users T2 ON T2.id = T1.userId LEFT JOIN persons T6 ON T6.id = T1.personId LEFT JOIN program_batch_students T66 ON T66.admissionId = T3.id AND T66.isCurrentSection = TRUE AND T66.isCurrentPeriod = TRUE LEFT JOIN user_academy_locations T15 ON T2.id = T15.userId AND T15.WHETHERPRIMARY = TRUE LEFT JOIN users T101 ON T101.id = T6.advisorId LEFT JOIN religions T25 ON T6.religionId = T25.id LEFT JOIN nationalities T23 ON T6.nationalityId = T23.id LEFT JOIN person_relationships T29 ON T6.id = T29.personId AND T29.relationship = \'MOTHER\' AND T29.whetherDeleted = FALSE LEFT JOIN person_addresses T59 ON T59.personId = T6.id AND T59.whetherPrimary = TRUE AND T59.whetherDeleted = FALSE LEFT JOIN gender TG104 ON T6.genderId = TG104.id LEFT JOIN drop_down T97 ON T6.homeLanguage = T97.id LEFT JOIN person_relationships T20 ON T6.id = T20.personId AND T20.relationship = \'GUARDIAN\' AND T20.whetherDeleted = FALSE LEFT JOIN person_relationships T17 ON T6.id = T17.personId AND T17.relationship = \'FATHER\' AND T17.whetherDeleted = FALSE LEFT JOIN student_hostel_requirement T100 ON T100.personId = T6.id AND T100.whetherDeleted = FALSE LEFT JOIN caste_categories T22 ON T6.castCategoryId = T22.id LEFT JOIN prog_batch_period_config T65 ON T65.id = T66.progBatchPeriodConfigId LEFT JOIN prog_batch_seat_config T74 ON T74.id = T66.progBatchSeatConfigId LEFT JOIN sections T10 ON T10.id = T66.sectionId LEFT JOIN academy_location T16 ON T16.id = T15.academyLocationId LEFT JOIN persons T30 ON T30.id = T29.relatedPersonId AND T29.relationship = \'MOTHER\' AND T29.whetherDeleted = FALSE LEFT JOIN address T60 ON T60.id = T59.addressId LEFT JOIN persons T21 ON T21.id = T20.relatedPersonId AND T20.relationship = \'GUARDIAN\' AND T20.whetherDeleted = FALSE LEFT JOIN persons T18 ON T18.id = T17.relatedPersonId AND T17.relationship = \'FATHER\' AND T18.whetherDeleted = FALSE LEFT JOIN batches T70 ON T70.id = T65.programBatchId LEFT JOIN seat_types T72 ON T72.id = T74.seatTypeId LEFT JOIN salutations T98 ON T98.id = T30.salutationId LEFT JOIN city T61 ON T61.id = T60.cityId LEFT JOIN salutations T102 ON T102.id = T21.salutationId LEFT JOIN salutations T99 ON T99.id = T18.salutationId LEFT JOIN programs T71 ON T71.id = T70.programId LEFT JOIN intake_year T93 ON T93.id = T70.intakeYearId LEFT JOIN country T62 ON T62.id = T61.countryId LEFT JOIN country_region T91 ON T91.id = T61.countryRegionId LEFT JOIN program_category T92 ON T92.id = T71.programCategoryId WHERE T2.status = TRUE AND T3.activeStatus = TRUE AND T3.admissionDate <= NOW() AND T66.exitDate IS NULL','Summary','Number of Students (Active)',1,b'1','Active Students');
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (7,'number_of_students_inactive','SELECT \'Number of Students (Inactive)\' AS value, COUNT(*) AS code FROM students T1 LEFT JOIN admission T3 ON T3.studentId = T1.userId LEFT JOIN users T2 ON T2.id = T1.userId LEFT JOIN persons T6 ON T6.id = T1.personId LEFT JOIN program_batch_students T66 ON T66.admissionId = T3.id AND T66.isCurrentSection = TRUE AND T66.isCurrentPeriod = TRUE LEFT JOIN user_academy_locations T15 ON T2.id = T15.userId AND T15.WHETHERPRIMARY = TRUE LEFT JOIN users T101 ON T101.id = T6.advisorId LEFT JOIN religions T25 ON T6.religionId = T25.id LEFT JOIN nationalities T23 ON T6.nationalityId = T23.id LEFT JOIN person_relationships T29 ON T6.id = T29.personId AND T29.relationship = \'MOTHER\' AND T29.whetherDeleted = FALSE LEFT JOIN person_addresses T59 ON T59.personId = T6.id AND T59.whetherPrimary = TRUE AND T59.whetherDeleted = FALSE LEFT JOIN gender TG104 ON T6.genderId = TG104.id LEFT JOIN drop_down T97 ON T6.homeLanguage = T97.id LEFT JOIN person_relationships T20 ON T6.id = T20.personId AND T20.relationship = \'GUARDIAN\' AND T20.whetherDeleted = FALSE LEFT JOIN person_relationships T17 ON T6.id = T17.personId AND T17.relationship = \'FATHER\' AND T17.whetherDeleted = FALSE LEFT JOIN student_hostel_requirement T100 ON T100.personId = T6.id AND T100.whetherDeleted = FALSE LEFT JOIN caste_categories T22 ON T6.castCategoryId = T22.id LEFT JOIN prog_batch_period_config T65 ON T65.id = T66.progBatchPeriodConfigId LEFT JOIN prog_batch_seat_config T74 ON T74.id = T66.progBatchSeatConfigId LEFT JOIN sections T10 ON T10.id = T66.sectionId LEFT JOIN academy_location T16 ON T16.id = T15.academyLocationId LEFT JOIN persons T30 ON T30.id = T29.relatedPersonId AND T29.relationship = \'MOTHER\' AND T29.whetherDeleted = FALSE LEFT JOIN address T60 ON T60.id = T59.addressId LEFT JOIN persons T21 ON T21.id = T20.relatedPersonId AND T20.relationship = \'GUARDIAN\' AND T20.whetherDeleted = FALSE LEFT JOIN persons T18 ON T18.id = T17.relatedPersonId AND T17.relationship = \'FATHER\' AND T18.whetherDeleted = FALSE LEFT JOIN batches T70 ON T70.id = T65.programBatchId LEFT JOIN seat_types T72 ON T72.id = T74.seatTypeId LEFT JOIN salutations T98 ON T98.id = T30.salutationId LEFT JOIN city T61 ON T61.id = T60.cityId LEFT JOIN salutations T102 ON T102.id = T21.salutationId LEFT JOIN salutations T99 ON T99.id = T18.salutationId LEFT JOIN programs T71 ON T71.id = T70.programId LEFT JOIN intake_year T93 ON T93.id = T70.intakeYearId LEFT JOIN country T62 ON T62.id = T61.countryId LEFT JOIN country_region T91 ON T91.id = T61.countryRegionId LEFT JOIN program_category T92 ON T92.id = T71.programCategoryId WHERE T2.status = FALSE AND T3.activeStatus = FALSE AND T3.admissionDate <= NOW() AND T66.exitDate IS NOT NULL;','\0','Number of Students (Inactive)',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (8,'facilities_and_masterclassrooms','SELECT \'Facilities and master(Classrooms)\' AS value, COUNT(resources.id) AS code FROM resources JOIN resource_types ON resources.resourceTypeId = resource_types.id WHERE status = \'ACTIVE\' AND typeName = \'Class Room\' AND whetherDeleted = 0;','\0','Facilities and master(Classrooms)',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (9,'committee','SELECT \'Facilitie\' AS value, COUNT(DISTINCT this_.id) AS code FROM committee this_ LEFT OUTER JOIN committee_participant committeep3_ ON this_.id = committeep3_.committeeId INNER JOIN users participan4_ ON committeep3_.participantId = participan4_.id WHERE this_.status = 1;','\0','Facilitie',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (10,'attendance_sessions_during_the_month_cbc','SELECT \'Attendance Sessions during the month CBC\' AS value, COUNT(DISTINCT this_.id) AS code FROM course_coverage_plan this_ INNER JOIN course_variants coursevari7_ ON this_.courseVariantId = coursevari7_.id INNER JOIN program_batch_course_param param8_ ON coursevari7_.id = param8_.courseVarientId LEFT OUTER JOIN prog_batch_course_faculty paramfacul9_ ON param8_.id = paramfacul9_.progBatchCourseParamId INNER JOIN prog_batch_period_config period10_ ON param8_.progBatchPeriodConfigId = period10_.id WHERE DATE(this_.sessionDate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL -PARAM_MONTH MONTH) AND DATE(this_.sessionDate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL -PARAM_MONTH MONTH)) AND this_.whetherDeleted = FALSE;','Program & Courses','Attendance Sessions during the month',3,b'1',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (11,'attendance_sessions_during_the_month_pbc','SELECT \'Attendance Sessions during the month PBC\' AS value, COUNT(id) AS code FROM student_program_attendance WHERE DATE(lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL -PARAM_MONTH MONTH) AND DATE(lastUpdate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL -PARAM_MONTH MONTH));','Program & Courses','Attendance Sessions during the month',3,b'1',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (12,'homework_and_assignments_sent_during_the_month','SELECT \'Homework and Assignments sent during the month\' AS value, COUNT(id) AS code FROM course_hw_asignment WHERE DATE(lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL -PARAM_MONTH MONTH) AND DATE(lastUpdate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL -PARAM_MONTH MONTH));','Program & Courses','Homework and Assignments sent during the month',3,b'1',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (13,'marks_entries_during_the_month','SELECT \'Marks Entries during the month\' AS value, COUNT(id) AS code FROM examination_result WHERE DATE(lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL -PARAM_MONTH MONTH) AND DATE(lastUpdate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL -PARAM_MONTH MONTH)) AND status IS NOT NULL;','Examinations','Marks Entries during the month',5,b'1',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (14,'number_of_applications_created_during_the_month','SELECT \'Number of Applications created during the month\' AS value, COUNT(a.id) AS code FROM application a LEFT JOIN application_program T1 ON a.id = T1.applicationId WHERE DATE(applicationCreatedOn) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(applicationCreatedOn) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH)) AND a.currentStatus NOT IN (\'SOLD\', \'DIRECT_SUBMISSION_TOKEN_GENERATED\', \'FORM_SALE_TOKEN_GENERATED\');','Pre-Admission & Admission','Number of Applications created during the month',2,b'1',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (15,'academic_events_created_during_the_month','SELECT \'Academic Events created during the month\' AS value, COUNT(resource_bookings.id) AS code FROM resource_bookings JOIN booking_purposes ON resource_bookings.bookingPurposeId = booking_purposes.id WHERE booking_purposes.code = \'Academic\' AND DATE(resource_bookings.lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(resource_bookings.lastUpdate) >= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','\0','Academic Events created during the month',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (16,'number_of_marksheets_generated_during_the_month','SELECT \'Number of Marksheets generated during the month\' AS value, COUNT(id) AS code FROM marksheet_job_details WHERE DATE(lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(lastUpdate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','Examinations','Number of Marksheets generated during the month',5,b'1',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (17,'bills_generated_during_the_month','SELECT \'Bills generated during the month\' AS value, COUNT(id) AS code FROM bill_header WHERE DATE(billingDate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(billingDate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH)) AND billStatus NOT IN (\'CANCELLED\') AND raiseBillCategory = \'BILL_RECEIVABLE\' AND totalAmount IS NOT NULL;','Fees & Payments','Bills generated during the month',4,b'1',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (18,'receipts_generated_during_the_month','SELECT \'Receipts generated during the month\' AS value, COUNT(id) AS code FROM receipt_header rh WHERE DATE(transactionDate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(transactionDate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH)) AND rh.status NOT IN (\'CANCELLED\');','Fees & Payments','Receipts generated during the month',4,b'1',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (19,'receipts_generated_during_the_month_online_mode','SELECT \'Receipts generated during the month (Online Mode)\' AS value, COUNT(receipt_payment_instrument.id) AS code FROM receipt_payment_instrument JOIN receipt_header ON receipt_payment_instrument.receiptHeaderId = receipt_header.id WHERE DATE(receipt_payment_instrument.lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(receipt_payment_instrument.lastUpdate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','\0','Receipts generated during the month (Online Mode)',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (20,'receipts_generated_during_the_month_payment_gateways','SELECT \'Receipts generated during the month (Payment Gateways)\' AS value, COUNT(rh.id) AS code FROM receipt_header rh LEFT JOIN users u ON rh.collectedBy = u.id WHERE DATE(rh.transactionDate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(rh.transactionDate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH)) AND u.id IN (2, 3);','\0','Receipts generated during the month (Payment Gateways)',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (21,'no._of_emails_sent','SELECT \'No. Of Emails Sent\' AS value, COUNT(id) AS code FROM msg_recipient_log WHERE DATE(lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(lastUpdate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH)) AND msgDeliveryModeId = 1;','Summary','No. Of Emails Sent',1,b'1','No. of Emails sent');
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (22,'no._of_sms_sent','SELECT \'No. Of SMS Sent\' AS value, COUNT(id) AS code FROM msg_recipient_log WHERE DATE(lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(lastUpdate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH)) AND msgDeliveryModeId = 2;','\0','No. Of SMS Sent',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (23,'hostel_allocation','SELECT \'Hostel Allocation\' AS value, COUNT(id) AS code FROM hostel_room_allotment WHERE DATE(checkInDate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(checkOutDate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','\0','Hostel Allocation',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (24,'enquiries','SELECT \'Enquiries\' AS value, COUNT(id) AS code FROM enquiry WHERE DATE(lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(lastUpdate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','Pre-Admission & Admission','Enquiries',2,b'1',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (25,'non_academic_events_created_during_the_month','SELECT \'Non Academic Events created during the month\' AS value, COUNT(resource_bookings.id) AS code FROM resource_bookings JOIN booking_purposes ON resource_bookings.bookingPurposeId = booking_purposes.id WHERE booking_purposes.code = \'Academic\' AND DATE(resource_bookings.lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(resource_bookings.lastUpdate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','\0','Non Academic Events created during the month',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (26,'v2_leave_applications_during_the_month','SELECT \'Leave Applications during the month\' AS value, COUNT(id) AS code FROM hr_emp_leave_request WHERE DATE(requestDate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(requestDate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','Summary','Leave Applications during the month',1,b'1','Leave Applications');
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (27,'push_notifications_for_the_month','SELECT \'Push Notifications for the month\' AS value, COUNT(msg_recipient_log.id) AS code FROM msg_recipient_log JOIN msg_delivery_mode ON msg_recipient_log.msgDeliveryModeId = msg_delivery_mode.id WHERE code = \'PushNotification\' AND DATE(msg_recipient_log.lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(msg_recipient_log.lastUpdate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','\0','Push Notifications for the month',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (28,'number_of_student_request_during_the_month','SELECT \'Number of Student Request (during the month)\' AS value, COUNT(*) AS code FROM service_requests req JOIN students usr ON usr.userId = req.requester JOIN users stuUsr ON stuUsr.id = usr.userId WHERE DATE(requestDate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND requestDate <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','Summary','Number of Student Request (during the month)',1,b'0','Student Request');
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (29,'number_of_employee_request_during_the_month','SELECT \'Number of Employee Request (during the month)\' AS value, COUNT(*) AS code FROM service_requests req JOIN staffs emp ON emp.userId = req.requester JOIN users EmpUsr ON EmpUsr.id = emp.userId WHERE DATE(requestDate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND requestDate <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','\0','Number of Employee Request (during the month)',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (30,'number_of_students_documents_uploaded_during_the_month','SELECT \'Number of Students documents uploaded (during the month)\' AS value, COUNT(*) AS code FROM student_documents WHERE DATE(lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND lastUpdate <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','\0','Number of Students documents uploaded (during the month)',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (31,'number_of_staff_documents_uploaded_during_the_month','SELECT \'Number of Staff documents uploaded (during the month)\' AS value, COUNT(*) AS code FROM faculty_documents WHERE DATE(lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND lastUpdate <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','\0','Number of Staff documents uploaded (during the month)',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (32,'total_fee_plans_created_during_the_month','SELECT \'Total Fee Plans Created (during the month)\' AS value, COUNT(*) AS code FROM fee_plan WHERE lastUpdate >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND lastUpdate <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','\0','Total Fee Plans Created (during the month)',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (33,'is_password_policy_implemented_yes_or_no','SELECT \'Is Password Policy implemented Yes or No\' AS value, IFNULL(IF(COUNT(id) > 0, \'Yes\', \'No\'), \'No\') AS code FROM user_password_policy;','\0','Is Password Policy implemented Yes or No',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (34,'faculty_login_count_to_responsive_faculty_portal','SELECT \'Faculty login count to Responsive Faculty Portal\' AS value, IFNULL(COUNT(DISTINCT id), 0) AS code FROM user_login_history WHERE appUsageportal = \'RESPONSIVE_FACULTY_PORTAL\' AND DATE(loginTime) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(loginTime) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','\0','Faculty login count to Responsive Faculty Portal',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (35,'faculty_login_count_to_regular_faculty_portal','SELECT \'Faculty login count to regular faculty portal\' AS value, IFNULL(COUNT(DISTINCT userId), 0) AS code FROM user_login_history WHERE appUsageportal = \'FACULTY_PORTAL\' AND DATE(loginTime) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(loginTime) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','\0','Faculty login count to regular faculty portal',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (36,'student_birthday_msg','SELECT \'Student Birthday Msg\' AS value, COUNT(*) as code FROM msg_recipient_log INNER JOIN msg_delivery_mode ON msg_recipient_log.msgDeliveryModeId = msg_delivery_mode.id INNER JOIN msg_rcpnt_type_log ON msg_recipient_log.msgRecipientTypeLogId = msg_rcpnt_type_log.id INNER JOIN msg_log ON msg_rcpnt_type_log.msgLogId = msg_log.id INNER JOIN msg_event_config ON msg_log.msgEventCnfgId = msg_event_config.id LEFT OUTER JOIN adhoc_msg_event_config ON msg_event_config.id = adhoc_msg_event_config.msgEventCnfgId LEFT OUTER JOIN system_msg_event_config ON msg_event_config.id = system_msg_event_config.msgEventCnfgId LEFT OUTER JOIN system_msg_event ON system_msg_event_config.systemMsgEventId = system_msg_event.id WHERE system_msg_event.uiDisplayCode = \'Msg Birthday Greeting\' AND msg_recipient_log.msgDeliveryModeId = 1 AND DATE(msg_recipient_log.lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(msg_recipient_log.lastUpdate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH));','\0','Msg Birthday Greeting',NULL,b'0',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (37,'number_of_hall_tickets_generated','SELECT \'Number of Hall Tickets generated\' AS value, COUNT(*) as code from eval_group_hall_ticket WHERE DATE(lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(lastUpdate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH))','Examinations','Number of Hall Tickets generated',5,b'1',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (38,'credit_notes_generated_during_the_month','SELECT \'Credit Notes generated during the month\' AS value, COUNT(*) as code from bill_header where raiseBillCategory = \'BILL_PAYABLE\' and billStatus <> \'CANCELLED\' and DATE(lastUpdate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(lastUpdate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH))','Fees & Payments','Credit Notes generated during the month',4,b'1',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (39,'no_of_course_enrollments','SELECT \'No of Course Enrollments\' AS value, COUNT(*) as code from student_course_enrollment where exitDate is null AND DATE(enrollmentDate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(enrollmentDate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH))','Program & Courses','No of Course Enrollments',3,b'1',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (40,'number_of_admissions_during_the_month','SELECT \'Number of Admissions during the month\' AS value, COUNT(*) as code from admission where activeStatus = true AND DATE(admissionDate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(admissionDate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH))','Pre-Admission & Admission','Number of Admissions during the month',2,b'1',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (41,'no_of_timetable_session','SELECT \'No of timetable sessions\' AS value, COUNT(*) as code from course_coverage_plan where sessionStatus = \'Active\' AND DATE(sessionDate) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH) AND DATE(sessionDate) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY), INTERVAL - PARAM_MONTH MONTH))','Program & Courses','No of timetable sessions',3,b'1',NULL);
INSERT INTO `monthly_report_master` (`id`,`paramName`,`query`,`groupings`,`paramFullName`,`sequences`,`status`,`summary_display`) VALUES (42,'profile','SELECT \'No of timetable sessions\' AS value, COUNT(*) as code from application this_ left outer join application_form applicatio2_ on this_.applicationFormId=applicatio2_.id left outer join application_information_source applicatio4_ on this_.id=applicatio4_.applicationId left outer join enquiry_source applicatio5_ on applicatio4_.informationSourceId=applicatio5_.id left outer join academy_location issuedfrom3_ on this_.issuedFromAcademyLocation=issuedfrom3_.id left outer join applicant_person person1_ on this_.applicantPersonId=person1_.id where this_.whetherSignUp=true AND DATE(this_.applicationCreatedOn) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()),INTERVAL 1 DAY),INTERVAL - PARAM_MONTH MONTH) AND DATE(this_.applicationCreatedOn) <= LAST_DAY(DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()), INTERVAL 1 DAY),INTERVAL - PARAM_MONTH MONTH)) group by this_.id','Pre-Admission & Admission','Applicant Profile',2,b'1',NULL);

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230705174053__Update_monthlyReportMasterUpdatedSql () $$
DROP PROCEDURE IF EXISTS V20230705174053__Update_monthlyReportMasterUpdatedSql $$
DELIMITER ;