DELIMITER $$
DROP PROCEDURE IF EXISTS V20230707151919__Create_LeaveOfAbsenceMultiReason $$
CREATE PROCEDURE V20230707151919__Create_LeaveOfAbsenceMultiReason()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='leave_of_absence_request_multiple_reason')) THEN 
 CREATE TABLE `leave_of_absence_request_multiple_reason` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `leaveOfAbsenceRequestDetailId` BIGINT(20) NOT NULL,
  `leaveOfAbsenceReasonId` BIGINT(20) NULL,
  `reasonRemark` longtext NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_loa_multiple_reason_request_detail_idx` (`leaveOfAbsenceRequestDetailId` ASC),
  INDEX `fk_loa_request_multiple_reason_pw_reason_idx` (`leaveOfAbsenceReasonId` ASC),
  INDEX `fk_loa_request_multiple_reason_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_loa_multiple_reason_loaRequestDetail_id`
    FOREIGN KEY (`leaveOfAbsenceRequestDetailId`)
    REFERENCES `leave_of_absence_request_details` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	CONSTRAINT `fk_loa_request_multiple_reason_pw_reason_id`
    FOREIGN KEY (`leaveOfAbsenceReasonId`)
    REFERENCES `drop_down` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_loa_request_multiple_reasons_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF;

END $$
CALL V20230707151919__Create_LeaveOfAbsenceMultiReason () $$ 
DROP PROCEDURE IF EXISTS V20230707151919__Create_LeaveOfAbsenceMultiReason $$ 
DELIMITER ;