DELIMITER $$
DROP PROCEDURE IF EXISTS V20230710162129__Update_SystemMsgEventComplaint $$
CREATE PROCEDURE V20230710162129__Update_SystemMsgEventComplaint()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF EXISTS ((select * from system_msg_event where code='SERVICE_REQUEST_COMPLAINT')) THEN 
update system_msg_event
set code='SERVICE_REQUEST_GRIEVANCE',displayCode='Service Request Grievance',description='Service Request Grievance',uiDisplayCode='Service Request Grievance'
where code='SERVICE_REQUEST_COMPLAINT';

INSERT INTO `picklist_translation` (`key`, `en`)
values('SERVICE_REQUEST_GRIEVANCE','Service Request Grievance');
END IF; 

IF EXISTS ((select * from msg_template_config where code='SR Raise Complaint')) THEN 
update msg_template_config
set templateConfigName='SR Raise Grievance'
where code='SR Raise Complaint';
END IF; 

IF EXISTS ((select * from template_dtprovider where dataProviderName='MSG_SERVICE_REQUEST_COMPLAINT_TDP')) THEN 
update template_dtprovider
set dataProviderName='MSG_SERVICE_REQUEST_GRIEVANCE_TDP'
where dataProviderName='MSG_SERVICE_REQUEST_COMPLAINT_TDP';
END IF; 

IF EXISTS ((select * from msg_category where code='SERVICE_REQUEST_COMPLAINT')) THEN 
update msg_category
set code='SERVICE_REQUEST_GRIEVANCE'
where code='SERVICE_REQUEST_COMPLAINT';
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='SERVICE_REQUEST_GRIEVANCE' AND objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','SERVICE_REQUEST_GRIEVANCE','Service Request Grievance','Service Request Grievance',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='GRIEVANCE_TYPE' AND objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','GRIEVANCE_TYPE','Grievance Type','Grievance Type',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE keyName='MSG_SERVICE_REQUEST_GRIEVANCE_TDP' AND objectName='MESSAGING_TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('MESSAGING_TRANSLATIONS','MSG_SERVICE_REQUEST_GRIEVANCE_TDP','Service Request Grievance Data','Service Request Grievance Data',now(),1);
END IF;

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230710162129__Update_SystemMsgEventComplaint () $$
DROP PROCEDURE IF EXISTS V20230710162129__Update_SystemMsgEventComplaint $$
DELIMITER ;