DELIMITER $$
DROP PROCEDURE IF EXISTS V20230724212926__Create_StudentHealthDocumentUrl $$
CREATE PROCEDURE V20230724212926__Create_StudentHealthDocumentUrl()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_health_document_url')) THEN 
CREATE TABLE IF NOT EXISTS `student_health_document_url` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`healthId` bigint DEFAULT NULL,	
	`documentName` VARCHAR(255) DEFAULT NULL,
	`documentUrl` VARCHAR(500) DEFAULT NULL,		
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`lastUpdatedBy` BIGINT(20) NOT NULL,	
	PRIMARY KEY (`id`),
	CONSTRAINT `FK_StudentHealthDocumentUrl_SU_person` FOREIGN KEY (`healthId`) REFERENCES `student_health_details` (`id`),
CONSTRAINT `FK_StudentHealthDocumentUrl_SU_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `persons` (`id`))
ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230724212926__Create_StudentHealthDocumentUrl () $$ 
DROP PROCEDURE IF EXISTS V20230724212926__Create_StudentHealthDocumentUrl $$ 
DELIMITER ;