DELIMITER $$
DROP PROCEDURE IF EXISTS V20230727163519__Create_ServiceRequestSetupDatesTable $$
CREATE PROCEDURE V20230727163519__Create_ServiceRequestSetupDatesTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='service_request_setup_dates')) THEN 
CREATE TABLE `service_request_setup_dates` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `periodId` bigint(20) NOT NULL,
  `requestTypeId` bigint(20) NOT NULL,
  `adminStartDate` date NOT NULL,
  `adminEndDate` date NOT NULL,
  `studentStartDate` date NOT NULL,
  `studentEndDate` date NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `prog_batch_period_config_fkx_idx1` (`periodId` ASC),
  CONSTRAINT `service_request_setup_dates_periodId_fk` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`) ON DELETE restrict ON UPDATE restrict,
  CONSTRAINT `service_request_setup_dates_requestTypeId_fk` FOREIGN KEY (`requestTypeId`) REFERENCES `request_types` (`id`) ON DELETE restrict ON UPDATE restrict,
  CONSTRAINT `service_request_setup_dates_lastUpdatedBy_fk` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE restrict ON UPDATE restrict
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230727163519__Create_ServiceRequestSetupDatesTable () $$ 
DROP PROCEDURE IF EXISTS V20230727163519__Create_ServiceRequestSetupDatesTable $$ 
DELIMITER ;