DELIMITER $$
DROP PROCEDURE IF EXISTS V20230731194125__Alter_ApplicantDetailDocumentUpdate $$
CREATE PROCEDURE V20230731194125__Alter_ApplicantDetailDocumentUpdate()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='applicant_detail_document' AND column_name='applicantLanguageDetailId')) THEN 
ALTER TABLE  applicant_detail_document 
DROP FOREIGN KEY applicant_passport_detail_document_FK;
ALTER TABLE applicant_detail_document 
ADD COLUMN applicantLanguageDetailId BIGINT NULL AFTER lastUpdatedBy,
CHANGE COLUMN applicantPassportDetailId applicantPassportDetailId BIGINT NULL ,
ADD INDEX applicant_language_id_FK_idx (`applicantLanguageDetailId` ASC) VISIBLE;

ALTER TABLE applicant_detail_document 
ADD CONSTRAINT applicant_passport_detail_document_FK
  FOREIGN KEY (`applicantPassportDetailId`)
  REFERENCES applicant_passport_detail (`id`),
ADD CONSTRAINT applicant_language_id_FK
  FOREIGN KEY (`applicantLanguageDetailId`)
  REFERENCES applicant_language (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

END IF; 

END $$
CALL V20230731194125__Alter_ApplicantDetailDocumentUpdate() $$
DROP PROCEDURE IF EXISTS V20230731194125__Alter_ApplicantDetailDocumentUpdate $$
DELIMITER ;