DELIMITER $$
DROP PROCEDURE IF EXISTS V20230801113009__Create_ApplicantPermitDetailTable $$
CREATE PROCEDURE V20230801113009__Create_ApplicantPermitDetailTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_permit_detail')) THEN 
CREATE TABLE `applicant_permit_detail` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
    `applicantPersonId` BIGINT(20) NOT NULL,
    `permitTypeId` BIGINT(20) NOT NULL,
    `cantonOfIssueId` BIGINT(20) NULL DEFAULT NULL,
    `countryOfIssueId` BIGINT(20) NULL DEFAULT NULL,
    `isPermitWithFamily` BIT(1) NOT NULL DEFAULT b'0',
    `permitStartDate` DATE NULL DEFAULT NULL,
    `permitExpirationDate` DATE NULL DEFAULT NULL,
    `permitCancellationDate` DATE NULL DEFAULT NULL,
    `dateOfDepartureAnnouncement` DATE NULL DEFAULT NULL,
    `reasonForPermitCancellation` VARCHAR(255) NULL DEFAULT NULL,
    `dateSubmittedToAuthorities` DATE NULL DEFAULT NULL,
    `methodOfSubmissionId` BIGINT(20) NULL DEFAULT NULL,
    `dateIssued` DATE NULL DEFAULT NULL,
    `dateCollected` DATE NULL DEFAULT NULL,
    `isPrimary` BIT(1) NOT NULL DEFAULT b'0',
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
    CONSTRAINT `fk_applicant_permit_detail_applicantPersonId` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person`(`id`),
    CONSTRAINT `fk_applicant_permit_detail_permitTypeId` FOREIGN KEY (`permitTypeId`) REFERENCES `drop_down`(`id`),
    CONSTRAINT `fk_applicant_permit_detail_cantonOfIssueId` FOREIGN KEY (`cantonOfIssueId`) REFERENCES `drop_down`(`id`),
    CONSTRAINT `fk_applicant_permit_detail_countryOfIssueId` FOREIGN KEY (`countryOfIssueId`) REFERENCES `country`(`id`),
    CONSTRAINT `fk_applicant_permit_detail_methodOfSubmissionId` FOREIGN KEY (`methodOfSubmissionId`) REFERENCES `drop_down`(`id`),
    CONSTRAINT `fk_applicant_permit_detail_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230801113009__Create_ApplicantPermitDetailTable () $$ 
DROP PROCEDURE IF EXISTS V20230801113009__Create_ApplicantPermitDetailTable $$ 
DELIMITER ;