DELIMITER $$
DROP PROCEDURE IF EXISTS V20230802142741__Create_StuHostelAplicationDetail $$
CREATE PROCEDURE V20230802142741__Create_StuHostelAplicationDetail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_hostel_application_detail')) THEN 
CREATE TABLE `student_hostel_application_detail` (
`id` bigint(20) NOT NULL AUTO_INCREMENT,
`studentId` bigint(20) NOT NULL,
`hostelId` bigint(20) NOT NULL,
`isReAllocateInSameHostel` bit(1) DEFAULT FALSE,
`academyLocationId` bigint(20) NULL DEFAULT NULL,
`applicationStatus` varchar(150) NOT NULL,
`allocatedHostelId` bigint(20) NULL DEFAULT NULL,
`applicationDate` date DEFAULT NULL,
`hostelSetupType` varchar(150) NOT NULL,
`hostelApplicationSetupId` bigint(20) DEFAULT NULL,
`yearOfApplication` varchar(255) DEFAULT NULL,
`lastUpdatedBy` bigint(20) NOT NULL,
`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,

PRIMARY KEY (`id`),
FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`),
FOREIGN KEY (`hostelId`) REFERENCES `hostel`(`id`),
FOREIGN KEY (`allocatedHostelId`) REFERENCES `hostel`(`id`),
FOREIGN KEY (`hostelApplicationSetupId`) REFERENCES `hostel_application_setup`(`id`),
FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`)
);
	
END IF; 

END $$
CALL V20230802142741__Create_StuHostelAplicationDetail () $$ 
DROP PROCEDURE IF EXISTS V20230802142741__Create_StuHostelAplicationDetail $$ 
DELIMITER ;