DELIMITER $$
DROP PROCEDURE IF EXISTS V20230822145101__Create_records_for_certificate $$
CREATE PROCEDURE V20230822145101__Create_records_for_certificate()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='graduation_records_for_certificate')) THEN 
CREATE TABLE `graduation_records_for_certificate` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `admissionId` BIGINT NOT NULL,
  `programId` BIGINT NOT NULL,
  `courseGroupNames` VARCHAR(255) NULL,
  `percentage` DOUBLE NULL,
  `whetherDistinction` BIT NOT NULL DEFAULT b'0',
  `graduationDate` DATE NULL DEFAULT NULL,
  `qrCode` VARCHAR(255) NULL,
  `barCode` VARCHAR(255) NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `createdDate` TIMESTAMP NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_certificate_admissionId_idx_idx` (`admissionId` ASC) VISIBLE,
  INDEX `fk_certificate_programId_idx_idx` (`programId` ASC) VISIBLE,
  INDEX `fk_certificate_userId_idx_idx` (`lastUpdatedBy` ASC) VISIBLE,
  UNIQUE INDEX `uq_certificate_unique_idx` (`admissionId` ASC, `programId` ASC) VISIBLE,
  CONSTRAINT `fk_certificate_admissionId_idx`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_certificate_programId_idx`
    FOREIGN KEY (`programId`)
    REFERENCES `programs` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_certificate_userId_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20230822145101__Create_records_for_certificate () $$ 
DROP PROCEDURE IF EXISTS V20230822145101__Create_records_for_certificate $$ 
DELIMITER ;