DELIMITER $$
DROP PROCEDURE IF EXISTS V20230906174637__Alter_sch_awardee_setup_addColumns $$
CREATE PROCEDURE V20230906174637__Alter_sch_awardee_setup_addColumns()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='scholarship_awardee_list_setup' AND column_name in ("nominationId", "billHeaderId", "remark")))THEN 
ALTER TABLE `scholarship_awardee_list_setup` 
ADD COLUMN `nominationId`  BIGINT DEFAULT NULL AFTER `scholarshipRaiseRequestId`,
ADD COLUMN `billHeaderId`  BIGINT DEFAULT NULL AFTER `applicantId`,
ADD COLUMN `remark`  varchar(255) DEFAULT NULL AFTER `status`;


ALTER TABLE `scholarship_awardee_list_setup` 
ADD CONSTRAINT `fk_sch_awardList_setup_nominationId`
  FOREIGN KEY (`nominationId`)
  REFERENCES `scholarship_nominate_or_award` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
  ADD CONSTRAINT `fk_sch_awardList_setup_billHeaderId`
  FOREIGN KEY (`billHeaderId`)
  REFERENCES `bill_header` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
END IF;
END $$

CALL V20230906174637__Alter_sch_awardee_setup_addColumns() $$
DROP PROCEDURE IF EXISTS V20230906174637__Alter_sch_awardee_setup_addColumns $$
DELIMITER ;