DELIMITER $$
DROP PROCEDURE IF EXISTS V20230908182744__Create_SalesForceStudentProgram $$
CREATE PROCEDURE V20230908182744__Create_SalesForceStudentProgram()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='salesforce_student_program')) THEN 
CREATE TABLE IF NOT EXISTS `salesforce_student_program` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`personId` BIGINT(20) NOT NULL,
	`applicationId` BIGINT(20) NOT NULL,
    `countryOfRecruitmentId` BIGINT(20) NOT NULL,
    `salesForceApplication` VARCHAR(255) NOT NULL,
    `salesForceStage` VARCHAR(255) NOT NULL,
    `verticalArea` VARCHAR(255) DEFAULT NULL,
    `subProgram1` VARCHAR(255) DEFAULT NULL,
    `subProgram2` VARCHAR(255) DEFAULT NULL,
    `deliveryMode` VARCHAR(255) DEFAULT NULL,
    `articulationAgreementNote` VARCHAR(255) DEFAULT NULL,
    `admissionComments` VARCHAR(255) DEFAULT NULL,
    `scholarshipName` VARCHAR(255) DEFAULT NULL,
    `scholarshipDuration` VARCHAR(255) DEFAULT NULL,
    `isLateArrival` BIT(1) NOT NULL DEFAULT b'0',
    `isDirectEntry` BIT(1) NOT NULL DEFAULT b'0',
    `isTransferCase` BIT(1) NOT NULL DEFAULT b'0',
    `applicantPortalContact` VARCHAR(255) DEFAULT NULL,
    `ecCommissionAccount` VARCHAR(255) DEFAULT NULL,
    `applicationOwner` VARCHAR(255) DEFAULT NULL,
    `sommetProgramID` VARCHAR(255) NOT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
    CONSTRAINT `fk_salesforce_student_program_personId_idx` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_salesforce_student_program_applicationId_idx` FOREIGN KEY (`applicationId`) REFERENCES `application` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    CONSTRAINT `fk_salesforce_student_program_countryOfRecruitmentId_idx` FOREIGN KEY (`countryOfRecruitmentId`) REFERENCES `country` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20230908182744__Create_SalesForceStudentProgram () $$ 
DROP PROCEDURE IF EXISTS V20230908182744__Create_SalesForceStudentProgram $$ 
DELIMITER ;