DELIMITER $$
DROP PROCEDURE IF EXISTS V20231225160702__Insert_EmailPassoutCertificate $$
CREATE PROCEDURE V20231225160702__Insert_EmailPassoutCertificate()
BEGIN

IF NOT EXISTS ((select id from system_msg_event where code='EMAIL_PASSOUT_CERTIFICATE')) THEN 

SET @parentcategoryId=(select id from msg_category where code="EXAMINATION");
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'EMAIL_PASSOUT_CERTIFICATE');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='EMAIL_PASSOUT_CERTIFICATE');

INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'EMAIL_PASSOUT_CERTIFICATE', 'Email Passout Certificate', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Email Passout Certificate');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'EMAIL_PASSOUT_CERTIFICATE_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'EMAIL_PASSOUT_CERTIFICATE_RECIPIENT', 'SQL');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EMAIL_PASSOUT_CERTIFICATE_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'EMAIL_PASSOUT_CERTIFICATE_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EMAIL_PASSOUT_CERTIFICATE_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='EMAIL_PASSOUT_CERTIFICATE_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EMAIL_PASSOUT_CERTIFICATE_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT T1.id as USER_ID FROM
        	 `completions` T1 
		      WHERE T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EMAIL_PASSOUT_CERTIFICATE_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT DISTINCT
   --  T12.programPeriodSeq,
    T2.id AS ID,
    T2.id AS JOB_ID,
    T4.printName AS FIRST_NAME,
    T4.code AS STUDENT_ID,
    T6.salutationName AS SALUTATION,
    T8.code AS APPLICATION_ID,
    T9.programCode AS PROGRAM_CODE,    
    T10.shortCode AS DEPARTMENT_CODE,
    T33.shortCode AS SUB_DEPARTMENT_CODE,
    
T11.startDate AS BATCH_START_DATE,
T12.printName AS PERIOD_PRINT_NAME,
date(now()) AS CURRENTDATE,
T13.itemValue AS STUDENT_GENDER,
date(T7.admissionDate) AS ADMISSION_DATE,
T14.groupName AS PROGRAM_GROUP_NAME,
T5.initials AS INITIAL,
T15.itemValue AS PROGRAM_MODE_OF_DELIVERY,
T5.id AS PERSON_ID,
T5.nationalID AS IDENTITY_NO,
T5.mobileNumber AS STUDENT_MOBILE_NO,
CONCAT(IFNULL(T5.emailId, ''), ', ', IFNULL(T5.alternateEmailId, '')) AS STUDENT_EMAIL_ID,
CONCAT(IFNULL(T5.emailId, ''), ', ', IFNULL(T32.emailId, '')) AS EMAIL_ID,
T4.printName AS STUDENT_NAME,
T9.programNameToBePrint AS PROGRAM_PRINT_NAME,
T10.deptName AS DEPARTMENT_NAME,
T33.deptName AS SUB_DEPARTMENT_NAME,
T11.tillDate AS BATCH_END_DATE,
T7.code AS ADMISSION_ID,
REPLACE(REPLACE(CONCAT(
    T18.orgName, ', ',T20.addressText,' (' ,
    IFNULL(T22.countryName, ''), ', ', IFNULL(T23.countryRegionName, ''), ', ',  IFNULL(T24.cityName, ''), ', ', 
    IFNULL(T20.pincode, ''), ', ', IFNULL(T20.phoneCountryCode, ''),' ',IFNULL(T20.phoneNo, ''), ', ',  
    IFNULL(T20.cellCountryCode, ''), ' ', IFNULL(T20.cellNo, ''),',',IFNULL(T20.primaryeEmailId, ''), ')'
),' ,',''),'(,','(') AS ORGANIZATION_NAME,

REPLACE(REPLACE(CONCAT(
    T16.displayName,', ',T26.addressText,' (', IFNULL(T27.countryName, ''), ', ', IFNULL(T28.countryRegionName, ''), ', ', 
    IFNULL(T29.cityName, ''), ', ', IFNULL(T26.pincode, ''), ', ', IFNULL(T26.phoneCountryCode, ''),' ',IFNULL(T26.phoneNo, ''), ', ', 
    IFNULL(T26.cellCountryCode, ''), ' ',  IFNULL(T26.cellNo, ''),', ',IFNULL(T26.primaryeEmailId, ''), ')'
),' ,',''),'(,','(') AS ACADEMY_LOCATION


FROM completions T2
INNER JOIN students T3 ON T2.studentId = T3.userId
INNER JOIN users T4 ON T3.userId = T4.id
INNER JOIN persons T5 ON T3.personId = T5.id
INNER JOIN salutations T6 ON T5.salutationId = T6.id
LEFT OUTER JOIN admission T7 ON T2.admissionId = T7.id
LEFT OUTER JOIN application_program T30 ON T7.applicationProgramId = T30.id
LEFT OUTER JOIN application T8 ON T30.applicationId = T8.id
LEFT OUTER JOIN programs T9 ON T2.programId = T9.id
LEFT OUTER JOIN department T10 ON T9.programDepartmentId = T10.id
LEFT OUTER JOIN batches T11 ON T2.batchId = T11.id
LEFT OUTER JOIN evaluation_plan_rank planRank ON planRank.admissionId=T2.admissionId
LEFT OUTER JOIN prog_batch_period_config T12 ON T12.id = planRank.periodId
LEFT OUTER JOIN gender T13 ON T5.genderId = T13.id
LEFT OUTER JOIN program_group T14 ON T9.programGroupId = T14.id
LEFT OUTER JOIN mode_of_delivery T15 ON T9.modeOfDeliveryId = T15.id
LEFT OUTER JOIN academy_location T16 ON T7.academyLocationId = T16.id
LEFT OUTER JOIN academies T17 ON T16.academyId = T17.id
LEFT OUTER JOIN organizations T18 ON T17.organizationId = T18.id
LEFT OUTER JOIN organization_addresses T19 ON T18.id = T19.organizationId AND T19.id=1
LEFT OUTER JOIN address T20 ON T19.addressId = T20.id
LEFT OUTER JOIN country T22 ON T20.countryId = T22.id
LEFT OUTER JOIN country_region T23 ON T20.countryRegionId = T23.id
LEFT OUTER JOIN city T24 ON T20.cityId = T24.id
LEFT OUTER JOIN academy_location_addresses T25 ON T16.id = T25.academyLocationId
LEFT OUTER JOIN address T26 ON T25.addressId = T26.id
LEFT OUTER JOIN country T27 ON T26.countryId = T27.id
LEFT OUTER JOIN country_region T28 ON T26.countryRegionId = T28.id
LEFT OUTER JOIN city T29 ON T26.cityId = T29.id
LEFT OUTER JOIN person_relationships T31 ON T5.id = T31.personId
LEFT OUTER JOIN persons T32 ON T31.relatedPersonId = T32.id
LEFT OUTER JOIN department T33 ON T9.subDepartmentId = T33.id

WHERE
       T2.id IN (namedParams)
       ORDER by T12.programPeriodSeq DESC
       LIMIT 1",'{
     "id": 1,
     "searchResultViewColumns": [
	  {
             "id": 1,
             "value": "studentId",
             "resultKey": "STUDENT_ID",
             "displayCode": "",
             "displayOrder": 0
	   },
        {
             "id": 2,
             "value": "salutation",
             "resultKey": "SALUTATION",
             "displayCode": "",
             "displayOrder": 1
	   },
 	    {
            "id": 3,
             "value": "applicationId",
             "resultKey": "APPLICATION_ID",
             "displayCode": "",
             "displayOrder": 2
 	    },
 	    {
            "id": 4,
             "value": "programCode",
             "resultKey": "PROGRAM_CODE",
             "displayCode": "",
             "displayOrder": 3
 	   },
       {
            "id": 5,
             "value": "deptCode",
             "resultKey": "DEPARTMENT_CODE",
             "displayCode": "",
             "displayOrder": 4
 	   },
       {
            "id": 6,
             "value": "subDeptCode",
             "resultKey": "SUB_DEPARTMENT_CODE",
             "displayCode": "",
             "displayOrder": 5
 	   },
       {
            "id": 7,
             "value": "batchStartDate",
             "resultKey": "BATCH_START_DATE",
             "displayCode": "",
             "displayOrder": 6
 	   },
       {
             "id": 8,
             "value": "periodPrintName",
             "resultKey": "PERIOD_PRINT_NAME",
             "displayCode": "",
             "displayOrder": 7
		},
		{
             "id": 9,
             "value": "currentDate",
             "resultKey": "CURRENTDATE",
             "displayCode": "",
             "displayOrder": 8
         },
         {
             "id": 10,
             "value": "gender",
             "resultKey": "STUDENT_GENDER",
             "displayCode": "",
             "displayOrder": 9
         },
         {
             "id": 11,
             "value": "admissionDate",
             "resultKey": "ADMISSION_DATE",
             "displayCode": "",
             "displayOrder": 10
         },
         {
             "id": 12,
             "value": "groupName",
             "resultKey": "PROGRAM_GROUP_NAME",
             "displayCode": "",
             "displayOrder": 11
         },
         {
             "id": 13,
             "value": "intials",
             "resultKey": "INITIAL",
             "displayCode": "",
             "displayOrder": 12
         },
         {
             "id": 14,
             "value": "modeOfDelivery",
             "resultKey": "PROGRAM_MODE_OF_DELIVERY",
             "displayCode": "",
             "displayOrder": 13
         },
         {
             "id": 15,
             "value": "IdentityNo",
             "resultKey": "IDENTITY_NO",
             "displayCode": "",
             "displayOrder": 14
         },
         {
             "id": 16,
             "value": "mobileNo",
             "resultKey": "STUDENT_MOBILE_NO",
             "displayCode": "",
             "displayOrder": 15
         },
         {
             "id": 17,
             "value": "studentEmail",
             "resultKey": "STUDENT_EMAIL_ID",
             "displayCode": "",
             "displayOrder": 16
         },
         {
             "id": 18,
             "value": "studentName",
             "resultKey": "STUDENT_NAME",
             "displayCode": "",
             "displayOrder": 17
         },
         {
             "id": 19,
             "value": "progPrintName",
             "resultKey": "PROGRAM_PRINT_NAME",
             "displayCode": "",
             "displayOrder": 18
         },
         {
             "id": 20,
             "value": "deptName",
             "resultKey": "DEPARTMENT_NAME",
             "displayCode": "",
             "displayOrder": 19
         },
         {
             "id": 21,
             "value": "subDeptName",
             "resultKey": "SUB_DEPARTMENT_NAME",
             "displayCode": "",
             "displayOrder": 20
         },
         {
             "id": 22,
             "value": "batchEndDate",
             "resultKey": "BATCH_END_DATE",
             "displayCode": "",
             "displayOrder": 21
         },
         {
             "id": 23,
             "value": "admissionId",
             "resultKey": "ADMISSION_ID",
             "displayCode": "",
             "displayOrder": 22
         },
         {
             "id": 24,
             "value": "orgName",
             "resultKey": "ORGANIZATION_NAME",
             "displayCode": "",
             "displayOrder": 23
         },
         {
             "id": 25,
             "value": "aLocName",
             "resultKey": "ACADEMY_LOCATION",
             "displayCode": "",
             "displayOrder": 24
         }
          
 ]}');

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='EMAIL_PASSOUT_CERTIFICATE');


SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='EMAIL_PASSOUT_CERTIFICATE');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='EMAIL_PASSOUT_CERTIFICATE_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Email Passout Certificate Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Email Passout Certificate Template',NULL,'',NULL,'','APPROVED','','1','System Admin','1','English',b'1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Your Academic Results',
'<html>
   <head>
   <p style="text-align:right"> $recipientData[&quot;CURRENTDATE&quot;]</p>
    <style>
		table, th, td {   
   		 border-collapse: collapse;   		
   		 text-align: center;
		}
	</style>
</html>
');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'4','Your Academic Results',
'<html>
   <head>
   <p style="text-align:right"> $recipientData[&quot;CURRENTDATE&quot;]</p>
    <style>
		table, th, td {   
   		 border-collapse: collapse;   		
   		 text-align: center;
		}
	</style>
   </head>
</html>
');
INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'6','Your Academic Results',
'<html>
   <head>
   <p style="text-align:right"> $recipientData[&quot;CURRENTDATE&quot;]</p>
    <style>
		table, th, td {   
   		 border-collapse: collapse;   		
   		 text-align: center;
		}
	</style>
   </head>
</html>
');
END IF;

END $$
CALL V20231225160702__Insert_EmailPassoutCertificate() $$
DROP PROCEDURE IF EXISTS V20231225160702__Insert_EmailPassoutCertificate $$
DELIMITER ;