DELIMITER $$
DROP PROCEDURE IF EXISTS V20231228125450__Insert_GEDUBillTemplate $$
CREATE PROCEDURE V20231228125450__Insert_GEDUBillTemplate()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE reportTypeId = '3' AND templateCode = 'MANAGE_BILLS_CODE' AND templateName='GEDU Invoice')) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES ('3', 'MANAGE_BILLS_CODE', 'GEDU Invoice', 'GEDUBBill.png', 'CommonReport_Bill_GEDU.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'GEDUBillWithGST.jasper', 'AcademiaLogo.png');

set @reportTempId= (select max(id) from report_template where templateCode ='MANAGE_BILLS_CODE');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId , 'TRANS_FEE_PLAN', 'Fee Plan Name', '1', NOW()),
(@reportTempId, 'TRANS_REFERENCE', 'Reference', '1', NOW()),
(@reportTempId, 'TRANS_INVOICE_QUANTITY', 'Invoice Quantity', '1', NOW()),
(@reportTempId, 'TRANS_AMOUNT', 'Amount', '1', NOW()),
(@reportTempId, 'TRANS_DISCOUNT', 'Discount', '1', NOW()),
(@reportTempId, 'TRANS_GST', 'GST', '1', NOW()),
(@reportTempId, 'TRANS_TOTAL_AMOUNT', 'Total Amount', '1', NOW());
END IF;  

END $$
CALL V20231228125450__Insert_GEDUBillTemplate() $$
DROP PROCEDURE IF EXISTS V20231228125450__Insert_GEDUBillTemplate $$
DELIMITER ;