DELIMITER $$
DROP PROCEDURE IF EXISTS V20240220160242__Create_StatementEmailSettingTable $$
CREATE PROCEDURE V20240220160242__Create_StatementEmailSettingTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='statement_email_setting')) THEN 
CREATE TABLE `statement_email_setting`( 
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
	`statementFor` varchar(20) NOT NULL,
	`languageId` BIGINT(20) NOT NULL,
	`reportTemplateId` BIGINT(20) NOT NULL,
	`messageTemplateId` BIGINT(20) NOT NULL,
	`isDefault` BIT(1) NOT NULL DEFAULT false,
	`isCorrespondenceLang` BIT(1) NOT NULL DEFAULT false,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	PRIMARY KEY (`id`), 
	CONSTRAINT `statement_email_setting_languageId_FK` FOREIGN KEY (`languageId`) REFERENCES `multi_language`(`id`),
	CONSTRAINT `statement_email_setting_reportTemplateId_FK` FOREIGN KEY (`reportTemplateId`) REFERENCES `report_template`(`id`),
	CONSTRAINT `statement_email_setting_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=INNODB; 
END IF; 

END $$
CALL V20240220160242__Create_StatementEmailSettingTable () $$ 
DROP PROCEDURE IF EXISTS V20240220160242__Create_StatementEmailSettingTable $$ 
DELIMITER ;