DELIMITER $$
DROP PROCEDURE IF EXISTS V20240319110039__Insert_PLJ_Makini_ReportCard $$
CREATE PROCEDURE V20240319110039__Insert_PLJ_Makini_ReportCard()
BEGIN

set @reportTypeTempId = (select max(id) from report_type where typeName='Mark Sheet' );

IF NOT EXISTS (select * from report_template where templateCode='PLJ_MAKINI_SCHOOL_EARLY_YEAR') THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeTempId, 'PLJ_MAKINI_SCHOOL_EARLY_YEAR', 'PLJ - Makini Schools Early Years', 'PLJ_MAKINI_SCHOOL_EARLY_YEAR.png', 'PLJ_MAKINI_SCHOOL_EARLY_YEAR_CommonReport.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'PLJ_MAKINI_SCHOOL_EARLY_YEAR.jasper', 'AcademiaLogo.png');
END IF;

set @tempId = (select max(id) from report_template where templateCode='PLJ_MAKINI_SCHOOL_EARLY_YEAR' and templateName='PLJ - Makini Schools Early Years');

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_PERSONAL_LEARNING_JOURNEY') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_PERSONAL_LEARNING_JOURNEY', 'PERSONAL LEARNING JOURNEY', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_NAME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_NAME', "Learner's name", '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_LEARNER_NO') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_LEARNER_NO', "Learner's number", '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DOB') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_DOB', 'Date of birth', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_TEACHER') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_TEACHER', 'Teacher', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempId AND keyValue='TRANS_DAYS_ABSENT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempId, 'TRANS_DAYS_ABSENT', 'Days Absent', '1', now());
END IF;

END $$
CALL V20240319110039__Insert_PLJ_Makini_ReportCard() $$
DROP PROCEDURE IF EXISTS V20240319110039__Insert_PLJ_Makini_ReportCard $$
DELIMITER ;