DELIMITER $$
DROP PROCEDURE IF EXISTS V20240417153939__Create_StudentAwardDeliveryMethodCSM $$
CREATE PROCEDURE V20240417153939__Create_StudentAwardDeliveryMethodCSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_award_delivery_method_csm')) THEN 
CREATE TABLE `student_award_delivery_method_csm` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

INSERT INTO student_award_delivery_method_csm (itemCode,itemValue, lastUpdate, lastUpdatedBy)  VALUES ('Nominated person','Nominated person',now(),1);
INSERT INTO student_award_delivery_method_csm (itemCode,itemValue, lastUpdate, lastUpdatedBy)  VALUES ('Registered mail','Registered mail',now(),1);

-- CSM Data

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'student_award_delivery_method_csm')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'student_award_delivery_method_csm','STUDENT_AWARD_DELIVERY_METHOD','Student Profile','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;

IF  EXISTS ((SELECT * FROM standard_master WHERE tableName = 'student_award_delivery_method_csm')) THEN 
SET @standardMasterId=(SELECT id FROM standard_master WHERE tableName = 'student_award_delivery_method_csm');

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());

END IF; 

-- ------------------TRANSLATION-------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' AND keyName = 'STUDENT_AWARD_DELIVERY_METHOD')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'STUDENT_AWARD_DELIVERY_METHOD', 'Award Delivery Method', 'Award Delivery Method','Toekenning afleweringsmetode','Phương thức giao giải thưởng',now(),1);
END IF;

END $$
CALL V20240417153939__Create_StudentAwardDeliveryMethodCSM () $$ 
DROP PROCEDURE IF EXISTS V20240417153939__Create_StudentAwardDeliveryMethodCSM $$ 
DELIMITER ;