DELIMITER $$
DROP PROCEDURE IF EXISTS V20240423144138__Create_ProgramCompletionDetails $$
CREATE PROCEDURE V20240423144138__Create_ProgramCompletionDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_completion_details')) THEN 
CREATE TABLE `program_completion_details`(
`id` bigint NOT NULL AUTO_INCREMENT,
`personId` bigint(20) NOT NULL,
`studentName` varchar(50) DEFAULT NULL,
`studentId` varchar(50) DEFAULT NULL,
`admissionId` bigint(20) DEFAULT NULL,
`programId` bigint(20) DEFAULT NULL,
`batchId` bigint(20) DEFAULT NULL,
`dateOfGraduation` date DEFAULT NULL,
`classificationId` bigint(20) DEFAULT NULL,
`isAlumni` BIT(1) DEFAULT NULL,
`specializationId` bigint(20) DEFAULT NULL,
`awardTypeId` bigint(20) DEFAULT NULL,
`awardCertificate` varchar(255) DEFAULT NULL,
`awardRequestedDate` date DEFAULT NULL,
`awardGivenDate` date DEFAULT NULL,
`awardDeliveryMethodId` bigint(20) DEFAULT NULL,
`awardNominatedPerson` varchar(255) DEFAULT NULL,
`awardTrackingNumber` varchar(255) DEFAULT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_programCompletionDetails_personId` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
CONSTRAINT `FK_programCompletionDetails_admissionId` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`),
CONSTRAINT `FK_programCompletionDetails_programId` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`),
CONSTRAINT `FK_programCompletionDetails_batchId` FOREIGN KEY (`batchId`) REFERENCES `batches`(`id`),
CONSTRAINT `FK_programCompletionDetails_classificationId` FOREIGN KEY (`classificationId`) REFERENCES `student_classification_csm`(`id`),
CONSTRAINT `FK_programCompletionDetails_specializationId` FOREIGN KEY (`specializationId`) REFERENCES `student_specialization_csm`(`id`),
CONSTRAINT `FK_programCompletionDetails_awardTypeId` FOREIGN KEY (`awardTypeId`) REFERENCES `academic_award`(`id`),
CONSTRAINT `FK_programCompletionDetails_awardDeliveryMethodId` FOREIGN KEY (`awardDeliveryMethodId`) REFERENCES `student_award_delivery_method_csm`(`id`)
 ) ;

END IF; 

END $$
CALL V20240423144138__Create_ProgramCompletionDetails () $$ 
DROP PROCEDURE IF EXISTS V20240423144138__Create_ProgramCompletionDetails $$ 
DELIMITER ;