drop event if exists delete_old_academia_job_logs;
delimiter $
CREATE DEFINER=`ss_root`@`%` EVENT `delete_old_academia_job_logs` ON SCHEDULE EVERY 1 DAY STARTS '2024-04-25 00:05:00' ON COMPLETION NOT PRESERVE DISABLE ON SLAVE DO BEGIN
        insert into hard_delete_files(filePath, fileName, moduleName, lastUpdatedBy)
                SELECT
                SUBSTRING(log.report, 1, LENGTH(log.report) - LENGTH(SUBSTRING_INDEX(log.report, '/', -1)) - 1) AS filePath,
                SUBSTRING_INDEX(log.report, '/', -1) AS fileName,
                'JOB_REPORT' as moduleName,
                case when log.triggeredBy is null then 1 else log.triggeredBy end as lastUpdatedBy
                from academia_job_detail_logs as log where log.report is not null and startTime < NOW() - INTERVAL 90 DAY;
        DELETE FROM academia_job_detail_logs
  WHERE startTime < NOW() - INTERVAL 90 DAY;
END$
delimiter ;





