DELIMITER $$
DROP PROCEDURE IF EXISTS V20240426120352__Create_Email_Certificate_ProgramWithdraw $$
CREATE PROCEDURE V20240426120352__Create_Email_Certificate_ProgramWithdraw()
BEGIN

-- START EC_WITHDRAW_FROM_PROGRAM

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='EC_WITHDRAW_FROM_PROGRAM')) THEN
 SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='STUDENT');
 SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
 INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'EC_WITHDRAW_FROM_PROGRAM');
 
 
 SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
 SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='EC_WITHDRAW_FROM_PROGRAM');
 INSERT INTO `system_msg_event`
 (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`)
 VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'EC_WITHDRAW_FROM_PROGRAM', 'Email Certificate Withdraw from Program', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Email Certificate Withdraw from Program');
 
 
 SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
 INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`)
 VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
 SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
 INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 
  -- Template data provider for the Event
  
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'EC_WITHDRAW_FROM_PROGRAM_DL', 'SQL');
 
 SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
 INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'EC_WITHDRAW_FROM_PROGRAM_RECIPIENT', 'SQL');
 
  -- Create Recipient Type
  
   SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EC_WITHDRAW_FROM_PROGRAM_RECIPIENT');
 INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'EC_WITHDRAW_FROM_PROGRAM_RECIPIENT');
 
 
 SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EC_WITHDRAW_FROM_PROGRAM_DL');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='EC_WITHDRAW_FROM_PROGRAM_RECIPIENT');
 INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`)
 VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);
  
  
 -- Setting the query for the Applicant distribution list
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EC_WITHDRAW_FROM_PROGRAM_DL');
 INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT T1.id AS USER_ID FROM completions T1 WHERE T1.id IN (namedParams)",NULL);
 
 -- Setting the query for the User Recipient
 
 SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
 SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EC_WITHDRAW_FROM_PROGRAM_RECIPIENT');
 INSERT INTO sql_dtprovider (id, dataProviderId, sqlQuery, jsonString) VALUES (@sqlDtproviderId+1,@dtproviderId,
 "SELECT 
	T1.id AS ID,
    T3.requesterType AS REQUESTER_BY,
    T3.requestDate AS REQUEST_DATE,
    T3.remarks AS REMARKS,
    T7.mobileNumber AS MOBILE_NO,
    T7.emailId AS EMAIL_ID,
    T7.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.code AS STUDENT_ID,
    T7.printName AS STUDENT_NAME,
    T8.salutationName AS SALUTATION,
    T9.itemValue AS STUDENT_GENDER,
    T4.code AS ADMISSION_ID,
    T4.admissionDate AS ADMISSION_DATE,
    T7.initials AS INITIALS,
    T7.nationalID AS IDENTITY_NUMBER,
    T11.programCode AS PROGRAMCODE,
    T11.programNameToBePrint AS PROGRAM_PRINT_NAME,
    CONCAT(T15.shortCode, '/', T15.deptName) AS PROGRAM_DEPARTMENT_NAME,
    CONCAT(T16.shortCode, '/', T16.deptName) AS PROGRAM_SUB_DEPARTMENT_NAME,
    T12.startDate AS INTAKE_START_DATE,
    T12.tillDate AS INTAKE_END_DATE,
    T13.printName AS PERIOD_PRINT_NAME,
    DATE(NOW()) AS TODAYS_DATE,
    T17.groupName AS PROGRAM_GROUP_NAME,
    T18.itemValue AS MODE_OF_DELIVERY,
    CONCAT(T19.displayName, ',', T20.locationName) AS ACADEMY_LOCATION_NAME,
    T22.addressText AS ACADEMY_ADDRESS,
    COALESCE(T22.postalCode,T22.pincode) AS ACADEMY_POSTALCODE,
    CONCAT(T22.phoneCountryCode, T22.phoneNo) AS ACADEMY_PHONE_NUMBER,
    CONCAT(T22.cellCountryCode, T22.cellNo) AS ACADEMY_MOBILE_NUMBER,
    T22.primaryeEmailId AS ACADEMY_EMAILID,
    T22.alternateEmailId AS ACADEMY_ALTERNATE_EMAILID,
    T23.countryName AS ACADEMY_COUNTRY_NAME,
    T24.cityName AS ACADEMY_CITY_NAME,
    T25.countryRegionName AS ACADEMY_REGION_NAME,
    T26.orgName AS ORGANIZATION_NAME,
    T28.addressText AS ORGANIZATION_ADDRESS,
    COALESCE(T28.postalCode,T28.pincode) AS Organization_postalCode,
    CONCAT(T28.phoneCountryCode, T28.phoneNo) AS ORGANIZATION_PHONE_NUMBER,
    CONCAT(T28.cellCountryCode, T28.cellNo) AS ORGANIZATION_MOBILE_NUMBER,
    T28.primaryeEmailId AS ORGANIZATION_EMAILID,
    T28.alternateEmailId AS ORGANIZATION_ALTERNATE_EMAILID,
    T29.countryName AS ORGANIZATION_COUNTRY_NAME,
    T30.cityName AS ORGANIZATION_CITY_NAME,
    T31.countryRegionName AS ORGANIZATION_REGION_NAME,
    T33.code AS APPLICANT_CODE,
    T34.printName AS APPLICANT_PRINT_NAME,
	T7.firstName AS FIRST_NAME
FROM
    completions T1
        LEFT OUTER JOIN
    program_withdrawals T2 ON T2.completionId = T1.id
        LEFT OUTER JOIN
    service_requests T3 ON T3.id = T2.serviceRequestId
        LEFT OUTER JOIN
    admission T4 ON T4.id = T1.admissionId
        LEFT OUTER JOIN
    users T5 ON T5.id = T4.studentId
        LEFT OUTER JOIN
    students T6 ON T6.userId = T5.id
        LEFT OUTER JOIN
    persons T7 ON T7.id = T6.personId
        LEFT OUTER JOIN
    salutations T8 ON T8.id = T7.salutationId
        LEFT OUTER JOIN
    gender T9 ON T9.id = T7.genderId
        LEFT OUTER JOIN
    programs T11 ON T11.id = T1.programId
        LEFT OUTER JOIN
    batches T12 ON T12.id = T1.batchId
        LEFT OUTER JOIN
    sections T14 ON T14.id = T1.sectionId
        LEFT OUTER JOIN
    prog_batch_period_config T13 ON T13.id = T14.periodId
        LEFT OUTER JOIN
    department T15 ON T15.id = T11.programDepartmentId
        LEFT OUTER JOIN
    department T16 ON T16.id = T11.subDepartmentId
        LEFT OUTER JOIN
    program_group T17 ON T17.id = T11.programGroupId
        LEFT OUTER JOIN
    mode_of_delivery T18 ON T18.id = T11.modeOfDeliveryId
        LEFT OUTER JOIN
    academy_location T19 ON T19.id = T4.academyLocationId
        LEFT OUTER JOIN
    locations T20 ON T20.id = T19.locationId
        LEFT OUTER JOIN
    location_addresses T21 ON T21.locationId = T20.id
        LEFT OUTER JOIN
    address T22 ON T22.id = T21.addressId
        LEFT OUTER JOIN
    city T24 ON T24.id = T22.cityId
        LEFT OUTER JOIN
    country T23 ON T23.id = T24.countryId
        LEFT OUTER JOIN
    country_region T25 ON T24.countryRegionId = T25.id
        LEFT OUTER JOIN
    organizations T26 ON T26.id = T20.organizationId
        LEFT OUTER JOIN
    organization_addresses T27 ON T27.organizationId = T20.organizationId
        LEFT OUTER JOIN
    address T28 ON T28.id = T27.addressId
        LEFT OUTER JOIN
    city T30 ON T30.id = T28.cityId
        LEFT OUTER JOIN
    country T29 ON T29.id = T30.countryId
        LEFT OUTER JOIN
    country_region T31 ON T31.id = T30.countryRegionId
        LEFT OUTER JOIN
    application_program T32 ON T32.id = T4.applicationProgramId
        LEFT OUTER JOIN
    application T33 ON T33.id = T32.applicationId
        LEFT OUTER JOIN
    applicant_person T34 ON T34.id = T33.applicantPersonId
WHERE
    T28.addressTypeId = 1 and
    T1.id IN (namedParams);",'{
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "orgName",
            "resultKey": "ORGANIZATION_NAME",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "addressText",
            "resultKey": "ORGANIZATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 1
        },       
        {
            "id": 3,
            "value": "countryName",
            "resultKey": "ORGANIZATION_COUNTRY_NAME",
            "displayCode": "",
            "displayOrder": 2
        },       
        {
            "id": 4,
            "value": "countryRegionName",
            "resultKey": "ORGANIZATION_REGION_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		
		{
            "id": 5,
            "value": "cityName",
            "resultKey": "ORGANIZATION_CITY_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "Organization_postalCode",
            "resultKey": "Organization_postalCode",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "ORGANIZATION_PHONE_NUMBER",
            "resultKey": "ORGANIZATION_PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 6
        },{
            "id": 8,
            "value": "ORGANIZATION_MOBILE_NUMBER",
            "resultKey": "ORGANIZATION_MOBILE_NUMBER",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id": 9,
            "value": "primaryeEmailId",
            "resultKey": "ORGANIZATION_EMAILID",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "alternateEmailId",
            "resultKey": "ORGANIZATION_ALTERNATE_EMAILID",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "ACADEMY_LOCATION_NAME",
            "resultKey": "ACADEMY_LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "addressText",
            "resultKey": "ACADEMY_ADDRESS",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "countryName",
            "resultKey": "ACADEMY_COUNTRY_NAME",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "countryRegionName",
            "resultKey": "ACADEMY_REGION_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "cityName",
            "resultKey": "ACADEMY_CITY_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "ACADEMY_POSTALCODE",
            "resultKey": "ACADEMY_POSTALCODE",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "ACADEMY_PHONE_NUMBER",
            "resultKey": "ACADEMY_PHONE_NUMBER",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "ACADEMY_MOBILE_NUMBER",
            "resultKey": "ACADEMY_MOBILE_NUMBER",
            "displayCode": "",
            "displayOrder": 17
        },
		{
            "id": 19,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_EMAILID",
            "displayCode": "",
            "displayOrder": 18
        },
		{
            "id": 20,
            "value": "code",
            "resultKey": "STUDENT_ID",
            "displayCode": "",
            "displayOrder": 19
        },
		{
            "id": 21,
            "value": "printName",
            "resultKey": "STUDENT_NAME",
            "displayCode": "",
            "displayOrder": 20
        },
		{
            "id": 22,
            "value": "salutationName",
            "resultKey": "SALUTATION",
            "displayCode": "",
            "displayOrder": 21
        },
		{
            "id": 23,
            "value": "code",
            "resultKey": "APPLICANT_CODE",
            "displayCode": "",
            "displayOrder": 22
        },
		{
            "id": 24,
            "value": "printName",
            "resultKey": "APPLICANT_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 23
        },
		{
            "id": 25,
            "value": "programCode",
            "resultKey": "PROGRAMCODE",
            "displayCode": "",
            "displayOrder": 24
        },
		{
            "id": 26,
            "value": "programNameToBePrint",
            "resultKey": "PROGRAM_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 25
        },
		{
            "id": 27,
            "value": "PROGRAM_DEPARTMENT_NAME",
            "resultKey": "PROGRAM_DEPARTMENT_NAME",
            "displayCode": "",
            "displayOrder": 26
        },
        {
            "id": 28,
            "value": "PROGRAM_SUB_DEPARTMENT_NAME",
            "resultKey": "PROGRAM_SUB_DEPARTMENT_NAME",
            "displayCode": "",
            "displayOrder": 27
        },
        {
            "id": 29,
            "value": "startDate",
            "resultKey": "INTAKE_START_DATE",
            "displayCode": "",
            "displayOrder": 28
        },
        {
            "id": 30,
            "value": "tillDate",
            "resultKey": "INTAKE_END_DATE",
            "displayCode": "",
            "displayOrder": 29
        },
        {
            "id": 31,
            "value": "printName",
            "resultKey": "PERIOD_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 30
        },
        {
            "id": 32,
            "value": "TODAYS_DATE",
            "resultKey": "TODAYS_DATE",
            "displayCode": "",
            "displayOrder": 31
        },
        {
            "id": 33,
            "value": "itemValue",
            "resultKey": "STUDENT_GENDER",
            "displayCode": "",
            "displayOrder": 32
        },
        {
            "id": 34,
            "value": "admissionDate",
            "resultKey": "ADMISSION_DATE",
            "displayCode": "",
            "displayOrder": 33
        },
		{
            "id": 35,
            "value": "code",
            "resultKey": "ADMISSION_ID",
            "displayCode": "",
            "displayOrder": 34
        },
		{
            "id": 36,
            "value": "groupName",
            "resultKey": "PROGRAM_GROUP_NAME",
            "displayCode": "",
            "displayOrder": 35
        },
		{
            "id": 37,
            "value": "initials",
            "resultKey": "INITIALS",
            "displayCode": "",
            "displayOrder": 36
        },
		{
            "id": 38,
            "value": "itemValue",
            "resultKey": "MODE_OF_DELIVERY",
            "displayCode": "",
            "displayOrder": 37
        },
		{
            "id": 39,
            "value": "idNumber",
            "resultKey": "IDENTITY_NUMBER",
            "displayCode": "",
            "displayOrder": 38
        },
		{
            "id": 40,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 39
        },
		{
            "id": 41,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 40
        },
		{
            "id": 42,
            "value": "alternateEmailId",
            "resultKey": "ALTERNATE_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 41
        },
		{
            "id": 43,
            "value": "requesterType",
            "resultKey": "REQUESTER_BY",
            "displayCode": "",
            "displayOrder": 42
        },
		{
            "id": 44,
            "value": "requestDate",
            "resultKey": "REQUEST_DATE",
            "displayCode": "",
            "displayOrder": 43
        },
		{
            "id": 45,
            "value": "remarks",
            "resultKey": "REMARKS",
            "displayCode": "",
            "displayOrder": 44
        },
		{
            "id": 46,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 45
        }
		
    ]
 }');
 
  SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
 SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='EC_WITHDRAW_FROM_PROGRAM_DL');
 SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
 INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
 
 SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
 SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='EC_WITHDRAW_FROM_PROGRAM');
 
 SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
 SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='EC_WITHDRAW_FROM_PROGRAM');
 SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='EC_WITHDRAW_FROM_PROGRAM_RECIPIENT');
 SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');
 
 INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`whetherEnabled`,`templatelanguageValue`)
 VALUES(@msgtemplateconfigId+1,'Email Certificate Withdraw from Program',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Email Certificate Withdraw from Program',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1',b'1','English');
 
 INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
 VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','','');
 
IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='EC_WITHDRAW_FROM_PROGRAM')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'EC_WITHDRAW_FROM_PROGRAM', 'Email Certificate Withdraw from Program', 'Email Certificate Withdraw from Program', 'E-possertifikaat Onttrek uit program', 'Rút chứng chỉ email khỏi chương trình',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='EC_WITHDRAW_FROM_PROGRAM_DL')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'EC_WITHDRAW_FROM_PROGRAM_DL', 'Email Certificate Withdraw from Program DL', 'Email Certificate Withdraw from Program DL', 'E-possertifikaat Onttrek uit Program DL', 'Rút chứng chỉ email khỏi chương trình DL',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName='MESSAGING_TRANSLATIONS' and keyName='EC_WITHDRAW_FROM_PROGRAM_RECIPIENT')) THEN 
INSERT INTO ui_translation (objectName, keyName, defaultValue, customerDefineValue, afriLanguage, vietLanguage,lastUpdate,lastUpdatedBy) 
VALUES ('MESSAGING_TRANSLATIONS', 'EC_WITHDRAW_FROM_PROGRAM_RECIPIENT', 'Email Certificate Withdraw from Program Recipient', 'Email Certificate Withdraw from Program Recipient', 'E-possertifikaat onttrek van programontvanger', 'Rút chứng chỉ email từ người nhận chương trình',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='EC_WITHDRAW_FROM_PROGRAM')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('EC_WITHDRAW_FROM_PROGRAM', 'Email Certificate Withdraw from Program');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='EC_WITHDRAW_FROM_PROGRAM_DL')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('EC_WITHDRAW_FROM_PROGRAM_DL', 'Email Certificate Withdraw from Program DL');
END IF;
  
IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='EC_WITHDRAW_FROM_PROGRAM_RECIPIENT')) THEN
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('EC_WITHDRAW_FROM_PROGRAM_RECIPIENT', 'Email Certificate Withdraw from Program Recipient');
END IF; 
 
END IF;
 
  
END $$
CALL V20240426120352__Create_Email_Certificate_ProgramWithdraw () $$ 
DROP PROCEDURE IF EXISTS V20240426120352__Create_Email_Certificate_ProgramWithdraw $$ 
DELIMITER ;