DELIMITER $$
DROP PROCEDURE IF EXISTS fatchCourseToBePushInBB $$
CREATE PROCEDURE fatchCourseToBePushInBB(jobLastRunTimestamp timestamp)
BEGIN
SELECT 
    cv.courseVariantCode AS courseVariantCode, course.courseName AS courseName, cv.id AS id,bbCourse.blackboardCourseId AS blackboardCourseId
FROM
    course_variants AS cv
        LEFT JOIN
    blackboard_course_mapping AS bbCourse ON bbCourse.academiaCourseVariantId = cv.id
        INNER JOIN
    courses AS course ON course.id = cv.courseId
        AND isLMSCourses IS TRUE 
        where bbCourse.id is null
UNION ALL SELECT 
    cv.courseVariantCode AS code,course.courseName AS value,cv.id AS id,bbCourse.blackboardCourseId AS blackboardCourseId
FROM
    course_variants AS cv
		JOIN
    blackboard_course_mapping AS bbCourse ON bbCourse.academiaCourseVariantId = cv.id
        INNER JOIN
    courses AS course ON course.id = cv.courseId AND isLMSCourses IS TRUE 
WHERE
    cv.lastUpdate > jobLastRunTimestamp;

END $$ 
DELIMITER ;