DELIMITER $$
DROP PROCEDURE IF EXISTS V20240524154046__Insert_BlackboardUserCreationNotification $$
CREATE PROCEDURE V20240524154046__Insert_BlackboardUserCreationNotification()
BEGIN
-- SYSTEM MSG EVENT ---------------------------------------------------------------------------------------------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `system_msg_event` WHERE `code`='BLACKBOARD_USER_CREATION_NOTIFICATION')) THEN 
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='USER_MGNT');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'BLACKBOARD_USER_CREATION_NOTIFICATION'); 

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='BLACKBOARD_USER_CREATION_NOTIFICATION');

INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'BLACKBOARD_USER_CREATION_NOTIFICATION','Blackboard User Creation Notification', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Blackboard User Creation Notification');

--  System Mgs Evt Default ----------------------------------------------------------------------------------------------------------------------------------------
SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

--  sys_msg_evt_default_scope ----------------------------------------------------------------------------------------------------------------------------------------
SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- DL data provider -------------------------------------------------------------------------------------------------------------------------------------------------------------
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BLACKBOARD_USER_CREATION_NOTIFICATION_DL', 'SQL');

-- Recipient Infor data provider -------------------------------------------------------------------------------------------------------------------------------------------------
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BLACKBOARD_USER_CREATION_NOTIFICATION_RECIPIENTS', 'SQL');

-- The under sql code gives for the user distribution list ,this information can be fetched
SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BLACKBOARD_USER_CREATION_NOTIFICATION_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='BLACKBOARD_USER_CREATION_NOTIFICATION_RECIPIENTS');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

-- Setting the query for the Parent distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BLACKBOARD_USER_CREATION_NOTIFICATION_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id AS USER_ID FROM users T1 where T1.id = (namedParams)",NULL);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BLACKBOARD_USER_CREATION_NOTIFICATION_RECIPIENTS');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"select T1.code as STUDENT_CODE,
T1.printName as PRINT_NAME,
T1.firstName as FIRST_NAME,
T1.lastName as LAST_NAME,
T5.displayName as ACADEMY_LOCATION_NAME,
T4.code as ADMISSION_ID,
T3.emailId as STUDENT_EMAIL_ADDRESS,
T8.programNameToBePrint as PROGRAM_PRINT_NAME,
T7.batchName as BATCH,
T9.programPeriodName as PERIOD,
concat(T14.countryName,', ',T13.countryRegionName,', ',T12.cityName,', ',T11.pincode,', ',T11.phoneNo,', ',T11.cellNo,', ',T11.primaryeEmailId) as STUDENT_ADDRESS,
T3.alternateEmailId as ALTERNATIVE_EMAIL_ID,
concat(T3.mobileCountryCode,'',T3.mobileNumber) as MOBILE_NUMBER,
T16.orgName as ORGANIZATION_NAME,
concat(T20.countryName,', ',T21.countryRegionName,', ',T19.cityName,', ',T18.pincode,', ',T18.phoneNo,', ',T18.cellNo,', ',T18.primaryeEmailId) as ORGANIZATION_ADDRESS,
T5.locationName as ACADEMY_LOCATION,
(Case 
    when T5.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T5.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T5.logoUrl)end) as LOGO_URL,
    (Case when T5.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T5.headerUrl) 
    else NULL end) as HEADER_URL,
        (Case when T5.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T5.footerUrl) 
    else NULL end) as FOOTER_URL 
from users as T1
inner join students as T2 on T2.userId=T1.id
left join persons as T3 on T3.id=T2.personId
left join admission as T4 on T4.studentId=T2.userId
left join academy_location as T5 on T5.id=T4.academyLocationId
left join program_batch_students T6 ON T6.admissionId = T5.id
LEFT JOIN batches T7 ON T7.id = T6.programBatchId
LEFT JOIN programs T8 ON T8.id = T7.programId
LEFT JOIN prog_batch_period_config T9 ON T9.id = T6.progBatchPeriodConfigId
LEFT JOIN academy_location_addresses T10 ON T10.academyLocationId = T4.academyLocationId
LEFT JOIN address T11 ON T11.id = T10.addressId AND T11.addressTypeId = 5
left join city T12 on T12.id=T11.cityId
left join country_region T13 on T13.id=T12.countryRegionId
left join country T14 on T14.id=T12.countryId
left join locations T15 on T14.id=T5.locationId
left join organizations T16 on T16.id=T15.organizationId
left join location_addresses T17 on T17.locationId=T15.id
left join address T18 on T18.id=T17.addressId and T18.addressTypeId = 3
left join city T19 on T19.id=T18.cityId
left join country T20 on T20.id=T18.countryId
left join country_region T21 on T21.id=T18.countryRegionId
left join organizations org on org.id = 1
where T1.id IN (namedParams) limit 1",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "STUDENT_CODE",
            "displayCode": "",
            "displayOrder": 0
        },{
            "id": 2,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 1
        },{
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "displayName",
            "resultKey": "ACADEMY_LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "code",
            "resultKey": "ADMISSION_ID",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "emailId",
            "resultKey": "STUDENT_EMAIL_ADDRESS",
            "displayCode": "",
            "displayOrder": 6
        },       
        {
            "id": 8,
            "value": "programNameToBePrint",
            "resultKey": "PROGRAM_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "batchName",
            "resultKey": "BATCH",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "programPeriodName",
            "resultKey": "PERIODE",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "student address",
            "resultKey": "STUDENT_ADDRESS",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "alternateEmailId",
            "resultKey": "ALTERNATIVE_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "mobile number",
            "resultKey": "MOBILE_NUMBER",
            "displayCode": "",
            "displayOrder": 12
        },       
        {
            "id": 14,
            "value": "orgName",
            "resultKey": "ORGANIZATION_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "organization address",
            "resultKey": "ORGANIZATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 14
        },
{
            "id": 16,
            "value": "locationName",
            "resultKey": "ACADEMY_LOCATION",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 17
        },
        {
            "id": 19,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 18
        }    ]
}');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='BLACKBOARD_USER_CREATION_NOTIFICATION');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='BLACKBOARD_USER_CREATION_NOTIFICATION');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='BLACKBOARD_USER_CREATION_NOTIFICATION_RECIPIENTS');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Blackboard User Creation Notification Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Blackboard User Creation Notification Template',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');

INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateconfigId+1,'1','','');

INSERT INTO `msg_template` (`msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateconfigId+1,'2','','');

END IF; 
END $$
CALL V20240524154046__Insert_BlackboardUserCreationNotification() $$
DROP PROCEDURE IF EXISTS V20240524154046__Insert_BlackboardUserCreationNotification $$
DELIMITER ;