DELIMITER $$
DROP PROCEDURE IF EXISTS V20240612143258__Create_AttestationStatementStudentJourney $$
CREATE PROCEDURE V20240612143258__Create_AttestationStatementStudentJourney()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_type` WHERE `typeName` = 'Attestation Statement Of Student Journey' )) THEN 
INSERT INTO `report_type` (`typeName`) VALUES ('Attestation Statement Of Student Journey');
END IF;

set @sommet = (select max(id) from report_type where typeName='Attestation Statement Of Student Journey' );
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY' and `templateName`='Attestation Statement Of Student Journey')) THEN 
 INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
	VALUES (@sommet, 'ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY', 'Attestation Statement of Student Journey', 'ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY.png', 'CommonReport_ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY.jasper', 'AcademiaLogo.png');
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE `reportTemplateId` = (select id from report_template where templateCode ='ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY'))) THEN
	set @H1 = (select id from report_template where templateCode ='ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY');
    INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@H1, 'TRANS_ATTESTATION','ATTESTATION', '1', NOW()),
	 (@H1, 'TRANS_STUDENT_NAME', 'Name:', '1', now()),
	 (@H1, 'TRANS_CERTIFY', 'This is to certify that', '1', now()),
	 (@H1, 'TRANS_STUDENT_FIRST_NAME', 'First name:', '1', now()),
	 (@H1, 'TRANS_STUDENT_NUMBER', 'Student number:', '1', now()),
	 (@H1, 'TRANS_BORN_ON', 'Born on:', '1', now()),
	 (@H1, 'TRANS_PASSPORT', 'Passport holder of:', '1', now()),
	 (@H1, 'TRANS_SUMMERY1', 'is enrolled as a full-time student in the program leading to the', '1', now()),
	 (@H1, 'TRANS_SUMMERY2', 'The student’s starting date of the program was on', '1', now()),
	 (@H1, 'TRANS_SUMMERY3', 'The student’s expected end date of the program is in', '1', now()),
	 (@H1, 'TRANS_SUMMERY4', 'The program mentioned above is normally', '1', now()),
	 (@H1, 'TRANS_SUMMERY5', 'in length.', '1', now()),
	 (@H1, 'TRANS_SUMMERY6', 'will follow our program as below:', '1', now()),
	 (@H1, 'TRANS_SUMMERY7', 'Our sole medium of instruction and assessment is English.', '1', now()),
	 (@H1, 'TRANS_SUMMERY8', 'GIHE is accredited in the United States by the New England Commission of Higher Education NECHE, formerly NEASC.', '1', now()),
	 (@H1, 'TRANS_SEMESTER', 'Semester', '1', now()),
	 (@H1, 'TRANS_LOCATION', 'Location', '1', now()),
	 (@H1, 'TRANS_SUMMERY9', 'at Glion Institute of Higher Education (GIHE).', '1', now()),
	 (@H1, 'TRANS_DATES', 'Dates', '1', now());
END IF;

END $$
CALL V20240612143258__Create_AttestationStatementStudentJourney () $$ 
DROP PROCEDURE IF EXISTS V20240612143258__Create_AttestationStatementStudentJourney $$ 
DELIMITER ;