DELIMITER $$
DROP PROCEDURE IF EXISTS V20240614171614__Create_canvasCourseSectionMapping $$
CREATE PROCEDURE V20240614171614__Create_canvasCourseSectionMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='canvas_course_section_mapping')) THEN 
CREATE TABLE canvas_course_section_mapping (
    id bigint NOT NULL AUTO_INCREMENT,
	canvasCourseMappingId bigint,
    canvasCourseSectionId bigint,
    academiaCourseVariantId bigint NOT NULL,
	academyLocationId bigint NOT NULL,
    remark VARCHAR(255),
    lastUpdatedBy bigint NOT NULL,
    lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_canvas_course_section_mapping_lastUpdatedBy_idx (lastUpdatedBy),
  KEY fk_canvas_course_section_mapping_academiaCourseVariantId_idx (academiaCourseVariantId),
  KEY fk_canvas_course_section_mapping_academyLocationId_idx (academyLocationId),
  KEY fk_canvas_course_section_mapping_canvasCourseMappingId_idx (canvasCourseMappingId),
  CONSTRAINT fk_canvas_course_section_mapping_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id),
  CONSTRAINT fk_canvas_course_section_mapping_academiaCourseVariantId FOREIGN KEY (academiaCourseVariantId) REFERENCES course_variants (id),
  CONSTRAINT fk_canvas_course_section_mapping_academyLocationId FOREIGN KEY (academyLocationId) REFERENCES academy_location (id),
  CONSTRAINT fk_canvas_course_section_mapping_canvasCourseMappingId FOREIGN KEY (canvasCourseMappingId) REFERENCES canvas_course_mapping (id)
) ENGINE=InnoDB;
END IF; 

END $$
CALL V20240614171614__Create_canvasCourseSectionMapping () $$ 
DROP PROCEDURE IF EXISTS V20240614171614__Create_canvasCourseSectionMapping $$ 
DELIMITER ;