DELIMITER $$

DROP PROCEDURE IF EXISTS V20240618184619__Alter_StdTrnsMultiReason $$
CREATE PROCEDURE V20240618184619__Alter_StdTrnsMultiReason()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.COLUMNS 
               WHERE table_schema=DATABASE() 
               AND table_name='student_transfer_request_details' 
               AND column_name='fromPeriodId') THEN 

    ALTER TABLE `student_transfer_request_details` 
    ADD COLUMN `fromPeriodId` BIGINT NULL DEFAULT NULL,
    ADD COLUMN `academicTermId` BIGINT NULL DEFAULT NULL,
    ADD COLUMN `isConfirmation` BIT(1) NULL DEFAULT b'0',
    ADD COLUMN `isAuthorizeDeclaration` BIT(1) NULL DEFAULT b'0',
    ADD COLUMN `visaRefusal` BIT(1) NULL DEFAULT b'0',
    ADD COLUMN `studiedInUk` BIT(1) NULL DEFAULT b'0',
    ADD COLUMN `isHealthInsurance` BIT(1) NULL DEFAULT b'0',
    ADD COLUMN `isScholarship` BIT(1) NULL DEFAULT b'0',
    ADD COLUMN `isMedicalIssues` BIT(1) NULL DEFAULT b'0',
    ADD COLUMN `isUpToDateDetails` BIT(1) NULL DEFAULT b'0',
    ADD INDEX `fk_fromPeriodId_idx` (`fromPeriodId` ASC),
    ADD INDEX `fk_academicTermId_idx` (`academicTermId` ASC);

    ALTER TABLE `student_transfer_request_details` 
    ADD CONSTRAINT `fk_fromPeriodId`
      FOREIGN KEY (`fromPeriodId`)
      REFERENCES `prog_batch_period_config` (`id`)
      ON DELETE NO ACTION
      ON UPDATE NO ACTION,
    ADD CONSTRAINT `fk_academicTermId`
      FOREIGN KEY (`academicTermId`)
      REFERENCES `academic_term` (`id`)
      ON DELETE NO ACTION
      ON UPDATE NO ACTION;

END IF;

END $$

CALL V20240618184619__Alter_StdTrnsMultiReason() $$

DROP PROCEDURE IF EXISTS V20240618184619__Alter_StdTrnsMultiReason $$

DELIMITER ;
