DELIMITER $$
DROP PROCEDURE IF EXISTS fatchCourseSecToBePushInCanvasST $$
CREATE PROCEDURE fatchCourseSecToBePushInCanvasST(jobLastRunTimestamp timestamp)
BEGIN
SELECT 
    cv.courseVariantCode AS courseVariantCode,
    cv.courseId AS courseId,
    cv.id AS id,
    1 AS locationId,
    canvasCourse.canvasCourseId AS canvasCourseId,
    canvasCourse.id AS canvasCourseMappingId,
    canvasCourseSection.id AS canvasCourseSectionId,
	period.programPeriodStart AS programPeriodStart,
    period.programPeriodEnd AS programPeriodEnd
FROM
    course_variants AS cv 
		join
	program_batch_course_param AS pbcp ON pbcp.courseVarientId=cv.id
		join
	prog_batch_period_config as period ON pbcp.progBatchPeriodConfigId=period.id
        inner JOIN
	canvas_course_mapping AS canvasCourse ON canvasCourse.academiaCourseId = cv.courseId
		left join 
	canvas_course_section_mapping as canvasCourseSection ON canvasCourseSection.academiaCourseVariantId=cv.id
        where canvasCourseSection.id is null  group by cv.id
UNION ALL SELECT 
    cv.courseVariantCode AS courseVariantCode,
    cv.courseId AS courseId,
    cv.id AS id,
    1 AS locationId,
    canvasCourse.canvasCourseId AS canvasCourseId,
    canvasCourse.id AS canvasCourseMappingId,
    canvasCourseSection.id AS canvasCourseSectionId,
	period.programPeriodStart AS programPeriodStart,
    period.programPeriodEnd AS programPeriodEnd
FROM
   course_variants AS cv 
		join
	program_batch_course_param AS pbcp ON pbcp.courseVarientId=cv.id
		join
	prog_batch_period_config as period ON pbcp.progBatchPeriodConfigId=period.id
         JOIN
	canvas_course_mapping AS canvasCourse ON canvasCourse.academiaCourseId = cv.courseId
		 join 
	canvas_course_section_mapping as canvasCourseSection ON canvasCourseSection.academiaCourseVariantId=cv.id
	WHERE
    cv.lastUpdate > jobLastRunTimestamp
    group by cv.id;
END $$ 
DELIMITER ;