DELIMITER $$
DROP PROCEDURE IF EXISTS V20240716124134__Create_ReadmissionReqDetail $$
CREATE PROCEDURE V20240716124134__Create_ReadmissionReqDetail()
BEGIN

IF NOT EXISTS (( SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='readmission_request_details')) THEN 
CREATE TABLE `readmission_request_details` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`planningToChangeProgram` BIT(1) NOT NULL DEFAULT b'0',
	`programChangeMotivationDoc` VARCHAR(255) NULL,
	`intendedALOfStudyId` BIGINT(20) NULL,
	`intendedProgramOfStudyId` BIGINT(20) NULL,
	`unRegAchievementReason` TEXT NULL,
	`unRegAchievementDoc` VARCHAR(255) NULL,
	`assistanceReason` TEXT NULL,
	`assistanceDoc` VARCHAR(255) NULL,
	`futureSucceedReason` TEXT NULL,
	`futureSucceedDoc` VARCHAR(255) NULL,
	`proofOfPaymentDoc` VARCHAR(255) NULL,
	`termsAndConditions` bit(1) NOT NULL DEFAULT b'0',
	`serviceRequestId` BIGINT(20) NOT NULL,
	`version` BIGINT(20) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	CONSTRAINT `readmission_req_alId_FK` FOREIGN KEY (`intendedALOfStudyId`) REFERENCES `academy_location`(`id`),
	CONSTRAINT `readmission_req_programId_FK` FOREIGN KEY (`intendedProgramOfStudyId`) REFERENCES `programs`(`id`),
	CONSTRAINT `readmission_req_service_reqId_FK` FOREIGN KEY (`serviceRequestId`) REFERENCES `service_requests`(`id`),
	CONSTRAINT `readmission_req_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB;
END IF; 

END $$
CALL V20240716124134__Create_ReadmissionReqDetail () $$ 
DROP PROCEDURE IF EXISTS V20240716124134__Create_ReadmissionReqDetail $$ 
DELIMITER ;