DELIMITER $$
DROP PROCEDURE IF EXISTS V20240718120239__Insert_EmailMarksGradeSubmission $$
CREATE PROCEDURE V20240718120239__Insert_EmailMarksGradeSubmission()
BEGIN

IF NOT EXISTS ((select id from system_msg_event where code='AUTOMATED_EMAIL_ON_SUBMISSION_OF_MARKS_GRADE')) THEN 

SET @parentcategoryId=(select id from msg_category where code="EXAMINATION");
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'AUTOMATED_EMAIL_ON_SUBMISSION_OF_MARKS_GRADE');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='AUTOMATED_EMAIL_ON_SUBMISSION_OF_MARKS_GRADE');

INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'AUTOMATED_EMAIL_ON_SUBMISSION_OF_MARKS_GRADE', 'Automated Email on submission of Marks/Grade ', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Automated Email on submission of Marks/Grade ');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'AUTOMATED_EMAIL_ON_SUBMISSION_OF_MARKS_GRADE_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'AUTOMATED_EMAIL_ON_SUBMISSION_OF_MARKS_GRADE_RECIPIENT', 'SQL');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='AUTOMATED_EMAIL_ON_SUBMISSION_OF_MARKS_GRADE_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'AUTOMATED_EMAIL_ON_SUBMISSION_OF_MARKS_GRADE_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='AUTOMATED_EMAIL_ON_SUBMISSION_OF_MARKS_GRADE_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='AUTOMATED_EMAIL_ON_SUBMISSION_OF_MARKS_GRADE_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='AUTOMATED_EMAIL_ON_SUBMISSION_OF_MARKS_GRADE_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT T1.id as USER_ID FROM
        	 `mark_entry_email_attachment` T1 
		      WHERE T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='AUTOMATED_EMAIL_ON_SUBMISSION_OF_MARKS_GRADE_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
        T12.`id` AS ID,
        T14.firstName AS FIRST_NAME,
        T14.lastName AS LAST_NAME,
        T14.`printName` AS USER_PRINT_NAME,
	    T14.emailId AS EMAIL_ID,
		T14.`code` AS USER_CODE,
	    T9.`courseCode` AS COURSE_CODE,
	    T9.`nameToBePrinted` AS COURSE_TITLE,
        T1.`courseVariantDescription` AS COURSEVARIANT_NAME,
	    T2.`printName` AS PERIOD_NAME,
        T8.`detailSequenceNumber` AS EVENT_NAME,
        T3.`evaluationPlanNumber` AS EVALUATION_PLAN,
        T12.`id` AS MEEA_ID
      
      
   FROM
            mark_entry_email_attachment T12 
            left join 
            course_variants T1 on T1.id=T12.courseVariantId
             left join 
            courses T9 on T9.id=T1.courseId
			left join
            prog_batch_period_config as T2 on T2.id=T12.periodId
            left join 
            evaluation_plan as T3 on T3.id=T12.evaluationPlanId
            left join
            users as T14 on T14.id=T12.facultyId	
            left join 
            academy_location T7 on T7.id=T1.academyLocationId
			left join 
            eval_seq_detail T8 on T8.id=T12.eventId
           
   WHERE
       T12.id IN (namedParams)  limit 1",'{
     "id": 1,
     "searchResultViewColumns": [
          {
             "id": 1,
             "value": "firstName",
             "resultKey": "FIRST_NAME",
             "displayCode": "",
             "displayOrder": 0
	      },
          {
             "id": 2,
             "value": "lastName",
             "resultKey": "LAST_NAME",
             "displayCode": "",
             "displayOrder": 1
	    },
        {
             "id": 3,
             "value": "emailId",
             "resultKey": "EMAIL_ID",
             "displayCode": "",
             "displayOrder": 2
	    },
	    {
             "id": 4,
             "value": "printName",
             "resultKey": "PERIOD_NAME",
             "displayCode": "",
             "displayOrder": 3
	    },
        {
             "id": 5,
             "value": "courseCode",
             "resultKey": "COURSE_CODE",
             "displayCode": "",
             "displayOrder": 4
	   },
       {
            "id": 6,
             "value": "nameToBePrinted",
             "resultKey": "COURSE_TITLE",
             "displayCode": "",
             "displayOrder": 5
 	   },
       {
            "id": 7,
             "value": "nameToBePrinted",
             "resultKey": "COURSEVARIANT_NAME",
             "displayCode": "",
             "displayOrder": 6
 	   },
       {
             "id": 8,
             "value": "evaluationPlanNumber",
             "resultKey": "EVALUATION_PLAN",
             "displayCode": "",
             "displayOrder": 7
		},
        {
             "id": 9,
             "value": "detailSequenceNumber",
             "resultKey": "EVENT_NAME",
             "displayCode": "",
             "displayOrder": 8
		}
 ]}');

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='AUTOMATED_EMAIL_ON_SUBMISSION_OF_MARKS_GRADE');


SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='AUTOMATED_EMAIL_ON_SUBMISSION_OF_MARKS_GRADE');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='AUTOMATED_EMAIL_ON_SUBMISSION_OF_MARKS_GRADE_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Automated Email on submission of Marks/Grade Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Automated Email on submission of Marks/Grade Template',NULL,'',NULL,'','APPROVED','','1','System Admin','1','English',b'1');
	

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Confirmation Email of Marks/Grade Submission',
'<html>
<head>
	<title></title>
</head>
<body>
<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Dear Faculty/Examination Department,</span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">This is an automated email to confirm the successful submission of marks/grades for the following:</span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Attached to this email, you will find the marks/grade document for your reference. Kindly review the document to ensure accuracy. If you have any questions or need further assistance, please feel free to reach out to "systems@anu.edu.in".</span></p>

<p><span style="color: rgb(23, 43, 77); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, Oxygen, Ubuntu, &quot;Fira Sans&quot;, &quot;Droid Sans&quot;, &quot;Helvetica Neue&quot;, sans-serif; font-size: 14px; letter-spacing: -0.07px; white-space: pre-line; background-color: rgb(235, 236, 240);">Thank you</span></p>
</body>
</html>

');
END IF;  

END $$
CALL V20240718120239__Insert_EmailMarksGradeSubmission() $$
DROP PROCEDURE IF EXISTS V20240718120239__Insert_EmailMarksGradeSubmission $$
DELIMITER ;