DELIMITER $$
DROP PROCEDURE IF EXISTS V20240802113208__Create_TermWiseRegistrationValidations $$
CREATE PROCEDURE V20240802113208__Create_TermWiseRegistrationValidations()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='term_wise_registration_validations')) THEN 
CREATE TABLE `term_wise_registration_validations` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `termWiseRegistrationId` bigint NOT NULL,
  `registrationValidation` varchar(255) NOT NULL,
  `whetherMandatory` bit(1) NOT NULL DEFAULT b'1',
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_term_wise_registration_validations_idx` (`termWiseRegistrationId`),
  KEY `term_wise_registration_validations_idx_1` (`lastUpdatedBy`),
  CONSTRAINT `fk_term_wise_registration_validations` FOREIGN KEY (`termWiseRegistrationId`) REFERENCES `registration_term_setup_detail` (`id`),
  CONSTRAINT `fk_term_wise_registration_validations_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20240802113208__Create_TermWiseRegistrationValidations () $$ 
DROP PROCEDURE IF EXISTS V20240802113208__Create_TermWiseRegistrationValidations $$ 
DELIMITER ;