DELIMITER $$
DROP PROCEDURE IF EXISTS V20240808175019__Create_passout_rule_details $$
CREATE PROCEDURE V20240808175019__Create_passout_rule_details()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='passout_rule_details')) THEN 
CREATE TABLE `passout_rule_details`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`passoutRuleId` BIGINT(20) NOT NULL,
	`numberOfCourses` INT(11) NULL DEFAULT NULL,
    `totalCredits` FLOAT(10,2) NULL DEFAULT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	INDEX `passout_rule_details_idx1` (`passoutRuleId` ASC),
	INDEX `passout_rule_details_idx2` (`lastUpdatedBy` ASC),
	CONSTRAINT `fk_passout_rule_details_1` FOREIGN KEY (`passoutRuleId`) REFERENCES `passout_rule`(`id`),
	CONSTRAINT `fk_passout_rule_details_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
    );
END IF; 

END $$
CALL V20240808175019__Create_passout_rule_details () $$ 
DROP PROCEDURE IF EXISTS V20240808175019__Create_passout_rule_details $$ 
DELIMITER ;