DELIMITER $$
DROP PROCEDURE IF EXISTS V20240808175931__Create_passout_rule_course_details $$
CREATE PROCEDURE V20240808175931__Create_passout_rule_course_details()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='passout_rule_course_details')) THEN 
CREATE TABLE `passout_rule_course_details`(
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`passoutRuleDetailsId` BIGINT(20) NOT NULL,
    `courseId` BIGINT(20) NOT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	INDEX `passout_rule_course_idx1` (`passoutRuleDetailsId` ASC),
	INDEX `passout_rule_course_idx2` (`courseId` ASC),
	INDEX `passout_rule_period_idx4` (`lastUpdatedBy` ASC),
	CONSTRAINT `fk_passout_rule_course_1` FOREIGN KEY (`passoutRuleDetailsId`) REFERENCES `passout_rule_details`(`id`),
    CONSTRAINT `fk_passout_rule_course_2` FOREIGN KEY (`courseId`) REFERENCES `courses`(`id`),
	CONSTRAINT `fk_passout_rule_course_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
    );

END IF; 

END $$
CALL V20240808175931__Create_passout_rule_course_details () $$ 
DROP PROCEDURE IF EXISTS V20240808175931__Create_passout_rule_course_details $$ 
DELIMITER ;