DELIMITER $$

DROP PROCEDURE IF EXISTS V20240816123505__Insert_ImportMarkRemarkNoteTranslation $$

CREATE PROCEDURE V20240816123505__Insert_ImportMarkRemarkNoteTranslation()
BEGIN
    -- Check if the entry does not exist
    IF NOT EXISTS (
        SELECT 1 
        FROM ui_translation 
        WHERE keyName = 'IMPORT_MARK_REMARK_NOTE' 
          AND objectName = 'EXAMINATION'
    ) THEN
        -- Insert new translation into ui_translation table
        INSERT INTO ui_translation (
            objectName, 
            keyName, 
            defaultValue, 
            customerDefineValue, 
            afriLanguage, 
            vietLanguage, 
            lastUpdate, 
            lastUpdatedBy
        ) 
        VALUES (
            'EXAMINATION',
            'IMPORT_MARK_REMARK_NOTE',
            'First Column will be "Student Code/Admission Code/External Reference 1", Second Column will be "Marks/Grades", and Third Column will be "Remarks/Comments".',
            'First Column will be "Student Code/Admission Code/External Reference 1", Second Column will be "Marks/Grades", and Third Column will be "Remarks/Comments".',
            'Eerste Kolom sal "Studentekode/Toelatingskode/Eksterne Verwysing 1" wees, Tweede Kolom sal "Punte/Grade" wees, en Derde Kolom sal "Opmerkings/Kommentaar" wees.',
            'Cột đầu tiên sẽ là "Mã sinh viên/Mã tuyển sinh/Tham chiếu bên ngoài 1", Cột thứ hai sẽ là "Điểm/Điểm số", và Cột thứ ba sẽ là "Nhận xét/Bình luận".',
            NOW(),
            1
        );
    END IF;
END $$

CALL V20240816123505__Insert_ImportMarkRemarkNoteTranslation() $$

DROP PROCEDURE IF EXISTS V20240816123505__Insert_ImportMarkRemarkNoteTranslation $$

DELIMITER ;