DELIMITER $$
DROP PROCEDURE IF EXISTS V20240830121225__Update_SendEmailForMonthlyUsage_addMonth $$
CREATE PROCEDURE V20240830121225__Update_SendEmailForMonthlyUsage_addMonth()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='SEND_EMAIL_FOR_MONTHLY_USAGE_DATA_RECIPIENT')) THEN 
SET @residenceRCPNT=(select id from dtprovider d WHERE d.dataProviderName='SEND_EMAIL_FOR_MONTHLY_USAGE_DATA_RECIPIENT' limit 1);
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
        T1.`id` AS ID,
        T1.`itemCode` AS FIRST_NAME,
        T1.`itemValue` AS EMAIL_ID,
        T2.id AS emailNo,
        DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 1 MONTH), \'%M\') AS MONTH_NAME
    FROM
        user_usage_email_internal T1
            LEFT JOIN
        send_monthly_report_path T2 ON 1 = 1
            AND DATE(T2.lastUpdate) = DATE(NOW())
    WHERE
        T1.id IN (namedParams)
    GROUP BY T1.id'
WHERE
   dataProviderId=@residenceRCPNT;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20240830121225__Update_SendEmailForMonthlyUsage_addMonth () $$
DROP PROCEDURE IF EXISTS V20240830121225__Update_SendEmailForMonthlyUsage_addMonth $$
DELIMITER ;