DELIMITER $$
DROP PROCEDURE IF EXISTS V20240906150726__Create_WhatsappConfiguration $$
CREATE PROCEDURE V20240906150726__Create_WhatsappConfiguration()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='whatsapp_configuration') THEN

CREATE TABLE IF NOT EXISTS `whatsapp_configuration` (
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
		`templateName` VARCHAR(255) NOT NULL,
		`activeStatus` Boolean DEFAULT false,
        `templateID` BIGINT(20),
        `numberofParameterRequired` BIGINT(20) NOT NULL,
        `value` varchar(255) DEFAULT NULL,
		`lastUpdatedBy` BIGINT(20) NOT NULL,
		`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP, 
		PRIMARY KEY (`id`),
		FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
	) ENGINE=InnoDB;

	SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
	SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);  
    
INSERT INTO standard_master(`id`, `tableName`, `masterName`,`moduleName`,`filterCode`, `whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
VALUES (@standardMasterMaxId + 1, 'whatsapp_configuration', 'WHATSAPP_CONFIGURATION','null','MASTER_WITH_AL', 0, 0, '1', NOW());


SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@ItemsMaxId + 1, 'templateName', 'TEMPLATE_NAME', @standardMasterMaxId + 1, 'varchar', '1', 0, 0, 1, 0, '1', NOW());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@ItemsMaxId + 1, 'templateID', 'TEMPLATE_ID', @standardMasterMaxId + 1, 'number', '2', 0, 0, 1, 0, '1', NOW());
 
SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@ItemsMaxId + 1, 'activeStatus', 'ACTIVE_STATUS', @standardMasterMaxId + 1, 'boolean', '3', 0, 0, 1, 0, '1', NOW());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@ItemsMaxId + 1, 'numberofParameterRequired', 'NUMBER_OF_PARAMETER_REQUIRED', @standardMasterMaxId + 1, 'number', '4', 0, 0, 1, 0, '1', NOW());


INSERT INTO whatsapp_configuration (templateName,activeStatus,templateID,numberofParameterRequired, lastUpdate, lastUpdatedBy)  VALUES ('Invoice',false,null,'6',now(),1);
INSERT INTO whatsapp_configuration (templateName,activeStatus,templateID,numberofParameterRequired, lastUpdate, lastUpdatedBy)  VALUES ('offer_letter',false,null,'4',now(),1);
INSERT INTO whatsapp_configuration (templateName,activeStatus,templateID,numberofParameterRequired, lastUpdate, lastUpdatedBy)  VALUES ('Marksheet',false,null,'5',now(),1);


IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='masterNames' and keyName='WHATSAPP_CONFIGURATION')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames','WHATSAPP_CONFIGURATION','Whatsapp Configuration','Whatsapp Configuration','Studente resultateverslag','Báo cáo kết quả học sinh',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='masterNames' and keyName='TEMPLATE_NAME')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames','TEMPLATE_NAME','Template Name','Template Name','Sjabloon Naam','Tên mẫu',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='masterNames' and keyName='TEMPLATE_ID')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames','TEMPLATE_ID','Template ID','Template ID','Sjabloon ID','ID mẫu',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='masterNames' and keyName='ACTIVE_STATUS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames','ACTIVE_STATUS','Active','Active','Aktief','Tích cực',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='masterNames' and keyName='NUMBER_OF_PARAMETER_REQUIRED')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames','NUMBER_OF_PARAMETER_REQUIRED','Number of Parameter Required','Number of Parameter Required','Nommer van parameter benodig','Số lượng tham số cần thiết',now(),1);
END IF;

END IF; 

END $$
CALL V20240906150726__Create_WhatsappConfiguration () $$ 
DROP PROCEDURE IF EXISTS V20240906150726__Create_WhatsappConfiguration $$ 
DELIMITER ;