DELIMITER $$
DROP PROCEDURE IF EXISTS V20241007145901__Create_NetworkChildGrid $$
CREATE PROCEDURE V20241007145901__Create_NetworkChildGrid()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='network')) THEN 
CREATE TABLE `network` (
  		`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
        `academyLocationId` BIGINT(20) NOT NULL,
  		`authApiKey` varchar(255) NOT NULL,
        `outletId` varchar(255) NOT NULL,
         `environment` varchar(255) NOT NULL,
         `currencyCode` varchar(255) NOT NULL,
		`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		`lastUpdatedBy` bigint(20) NOT NULL,
		PRIMARY KEY (`id`),
        INDEX `fk_academylocationid_idx` (`academyLocationId` ASC),
		INDEX `fk_nework_child_lastUpdatedBy_user_id_idx` (`lastUpdatedBy` ASC),
            CONSTRAINT `fk_academylocationid_idx`
		    FOREIGN KEY (`academyLocationId`)
		    REFERENCES `academy_location` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT,
	  	CONSTRAINT `fk_nework_child_lastUpdatedBy_user_id_idx`
		    FOREIGN KEY (`lastUpdatedBy`)
		    REFERENCES `users` (`id`)
		    ON DELETE RESTRICT
		    ON UPDATE RESTRICT
		) ;
END IF; 
   IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'network')) THEN 
  SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		INSERT INTO `standard_master`(`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@standardMasterMaxId+1, 'network','NETWORK','Payment Gateway','MASTER_WITH_AL',1,0,1,SYSDATE());
        SET SQL_SAFE_UPDATES = 0;
		SET @standardMasterId=(SELECT id FROM standard_master WHERE `tableName`='network');
		UPDATE `standard_master` SET `childMaster`=@standardMasterId, `whetherParent`=1 WHERE `tableName`='standard_payment_gateway';
        UPDATE  `standard_payment_gateway` SET `itemCode` = @standardMasterId WHERE (itemValue = 'network');
		SET SQL_SAFE_UPDATES = 1;
        SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`,`fkDisplayField`,`whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'academyLocation', 'ACADEMY_LOCATION', @standardMasterMaxId+1, 'Varchar', '1', 1,'academy_location', 'id','academyLocationName' ,0, 0, 0, '1',SYSDATE());
        SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'authApiKey', 'AUTH_API_KEY', @standardMasterMaxId+1, 'Varchar', '2', 0, 0, 0, 0, '1',SYSDATE());
        SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'outletId', 'OUTLET_ID', @standardMasterMaxId+1, 'Varchar', '3', 0, 0, 0, 0, '1',SYSDATE());
         SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'environment', 'ENVIRONMENT', @standardMasterMaxId+1, 'Varchar', '4', 0, 0, 0, 0, '1',SYSDATE());
        SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
		VALUES (@ItemsMaxId+1, 'currencyCode', 'CURRENCY_CODE', @standardMasterMaxId+1, 'Varchar', '5', 0, 0, 0, 0, '1',SYSDATE());
END IF;
END $$
CALL V20241007145901__Create_NetworkChildGrid () $$ 
DROP PROCEDURE IF EXISTS V20241007145901__Create_NetworkChildGrid $$ 
DELIMITER ;